/*
 * Decompiled with CFR 0.152.
 */
package io.socket.socketio.server;

import io.socket.socketio.server.SocketIoAdapter;
import io.socket.socketio.server.SocketIoMemoryAdapter;

public final class SocketIoServerOptions {
    public static final SocketIoServerOptions DEFAULT = new SocketIoServerOptions();
    private static final SocketIoAdapter.AdapterFactory MEMORY_ADAPTER_FACTORY = new SocketIoMemoryAdapter.Factory();
    private boolean mIsLocked = false;
    private SocketIoAdapter.AdapterFactory mAdapterFactory;

    private SocketIoServerOptions() {
    }

    public static SocketIoServerOptions newFromDefault() {
        return new SocketIoServerOptions().setAdapterFactory(DEFAULT.getAdapterFactory());
    }

    public SocketIoAdapter.AdapterFactory getAdapterFactory() {
        return this.mAdapterFactory;
    }

    public SocketIoServerOptions setAdapterFactory(SocketIoAdapter.AdapterFactory adapterFactory) throws IllegalStateException {
        if (this.mIsLocked) {
            throw new IllegalStateException("Adapter factory cannot be set. Instance is locked.");
        }
        if (adapterFactory == null) {
            adapterFactory = MEMORY_ADAPTER_FACTORY;
        }
        this.mAdapterFactory = adapterFactory;
        return this;
    }

    public void lock() {
        this.mIsLocked = true;
    }

    static {
        DEFAULT.setAdapterFactory(MEMORY_ADAPTER_FACTORY);
        DEFAULT.lock();
    }
}

