/*
 * Decompiled with CFR 0.152.
 */
package io.socket.socketio.server;

import io.socket.engineio.server.EngineIoServer;
import io.socket.engineio.server.EngineIoSocket;
import io.socket.parser.IOParser;
import io.socket.parser.Parser;
import io.socket.socketio.server.SocketIoAdapter;
import io.socket.socketio.server.SocketIoClient;
import io.socket.socketio.server.SocketIoNamespace;
import io.socket.socketio.server.SocketIoNamespaceGroupImpl;
import io.socket.socketio.server.SocketIoNamespaceImpl;
import io.socket.socketio.server.SocketIoNamespaceProvider;
import io.socket.socketio.server.SocketIoServerOptions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public final class SocketIoServer {
    private final SocketIoServerOptions mOptions;
    private final Map<Pattern, SocketIoNamespaceProvider> mNamespaceRegexProviderMap = new ConcurrentHashMap<Pattern, SocketIoNamespaceProvider>();
    private final Map<SocketIoNamespaceProvider, SocketIoNamespaceGroupImpl> mNamespaceGroups = new ConcurrentHashMap<SocketIoNamespaceProvider, SocketIoNamespaceGroupImpl>();
    private final Map<String, SocketIoNamespaceImpl> mNamespaces = new ConcurrentHashMap<String, SocketIoNamespaceImpl>();
    private final Parser.Encoder mEncoder = new IOParser.Encoder();

    public SocketIoServer(EngineIoServer server) {
        this(server, SocketIoServerOptions.DEFAULT);
    }

    public SocketIoServer(EngineIoServer server, SocketIoServerOptions options) {
        this.mOptions = options;
        this.mOptions.lock();
        this.namespace("/");
        server.on("connection", args -> {
            EngineIoSocket socket = (EngineIoSocket)args[0];
            SocketIoClient client = new SocketIoClient(this, socket);
            client.connect("/");
        });
    }

    Parser.Encoder getEncoder() {
        return this.mEncoder;
    }

    SocketIoAdapter.AdapterFactory getAdapterFactory() {
        return this.mOptions.getAdapterFactory();
    }

    boolean checkNamespace(String namespace) {
        if (namespace.charAt(0) != '/') {
            namespace = "/" + namespace;
        }
        for (SocketIoNamespaceProvider provider : this.mNamespaceGroups.keySet()) {
            if (!provider.checkNamespace(namespace)) continue;
            SocketIoNamespaceGroupImpl namespaceGroup = this.mNamespaceGroups.get(provider);
            SocketIoNamespaceImpl nsp = namespaceGroup.createChild(namespace);
            this.mNamespaces.put(namespace, nsp);
            return true;
        }
        return false;
    }

    public boolean hasNamespace(String namespace) {
        if (namespace.charAt(0) != '/') {
            namespace = "/" + namespace;
        }
        return this.mNamespaces.containsKey(namespace);
    }

    public synchronized SocketIoNamespace namespace(String namespace) {
        SocketIoNamespaceImpl nsp;
        if (namespace.charAt(0) != '/') {
            namespace = "/" + namespace;
        }
        if ((nsp = this.mNamespaces.get(namespace)) == null) {
            nsp = new SocketIoNamespaceImpl(this, namespace);
            this.mNamespaces.put(namespace, nsp);
        }
        return nsp;
    }

    public synchronized SocketIoNamespace namespace(SocketIoNamespaceProvider namespaceProvider) {
        SocketIoNamespaceGroupImpl nsp = this.mNamespaceGroups.get(namespaceProvider);
        if (nsp == null) {
            nsp = new SocketIoNamespaceGroupImpl(this);
            this.mNamespaceGroups.put(namespaceProvider, nsp);
        }
        return nsp;
    }

    public synchronized SocketIoNamespace namespace(Pattern namespaceRegex) {
        SocketIoNamespaceProvider provider = this.mNamespaceRegexProviderMap.computeIfAbsent(namespaceRegex, r -> namespace -> r.matcher(namespace).matches());
        return this.namespace(provider);
    }
}

