/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server.utils;

import java.security.SecureRandom;

public interface ServerYeast {
    public static final ThreadLocal<SecureRandom> THREAD_RANDOM = new ThreadLocal();
    public static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_".toCharArray();

    public static String yeast() {
        SecureRandom secureRandom = THREAD_RANDOM.get();
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
            THREAD_RANDOM.set(secureRandom);
        }
        return ServerYeast.encode(secureRandom.nextLong() & Long.MAX_VALUE);
    }

    public static String encode(long num) {
        StringBuilder encoded = new StringBuilder();
        long dividedNum = num;
        do {
            encoded.insert(0, ALPHABET[(int)(dividedNum % (long)ALPHABET.length)]);
        } while ((dividedNum /= (long)ALPHABET.length) > 0L);
        return encoded.toString();
    }
}

