/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server.parser;

import io.socket.engineio.server.parser.Packet;
import io.socket.engineio.server.parser.Parser;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public final class ParserV3
implements Parser {
    public static final int PROTOCOL = 3;

    @Override
    public int getProtocolVersion() {
        return 3;
    }

    @Override
    public void encodePacket(Packet<?> packet, boolean supportsBinary, Parser.EncodeCallback<Object> callback) {
        if (packet.data instanceof byte[]) {
            ParserV3.encodeByteArray(packet, supportsBinary, callback);
        } else {
            String encoded = String.valueOf(PACKETS.get(packet.type));
            if (null != packet.data) {
                encoded = encoded + String.valueOf(packet.data);
            }
            callback.call(encoded);
        }
    }

    public static void encodeByteArray(Packet<byte[]> packet, boolean supportsBinary, Parser.EncodeCallback<Object> callback) {
        if (supportsBinary) {
            byte[] data = (byte[])packet.data;
            byte[] resultArray = new byte[1 + data.length];
            resultArray[0] = ((Integer)PACKETS.get(packet.type)).byteValue();
            System.arraycopy(data, 0, resultArray, 1, data.length);
            callback.call(resultArray);
        } else {
            String resultBuilder = "b" + ((Integer)PACKETS.get(packet.type)).byteValue() + Base64.getEncoder().encodeToString((byte[])packet.data);
            callback.call(resultBuilder);
        }
    }

    @Override
    public void encodePayload(List<Packet<?>> packets, boolean supportsBinary, Parser.EncodeCallback<Object> callback) {
        boolean isBinary = false;
        for (Packet<?> packet : packets) {
            if (!(packet.data instanceof byte[])) continue;
            isBinary = true;
            break;
        }
        if (isBinary && supportsBinary) {
            this.encodePayloadAsBinary(packets, callback);
            return;
        }
        if (packets.size() == 0) {
            callback.call("0:");
            return;
        }
        StringBuilder result = new StringBuilder();
        for (Packet<?> packet : packets) {
            this.encodePacket(packet, false, data -> result.append(ParserV3.setLengthHeader((String)data)));
        }
        callback.call(result.toString());
    }

    @Override
    public void decodePayload(Object data, Parser.DecodePayloadCallback<Object> callback) {
        int payloadIdx;
        assert (callback != null);
        ArrayList packets = new ArrayList();
        if (data instanceof String) {
            String stringData = (String)data;
            payloadIdx = 0;
            while (payloadIdx < stringData.length()) {
                int separatorIdx = stringData.indexOf(58, payloadIdx);
                if (separatorIdx < 0) {
                    throw new IllegalArgumentException("Invalid payload: " + stringData);
                }
                int length = Integer.parseInt(stringData.substring(payloadIdx, separatorIdx));
                String packetData = stringData.substring(separatorIdx + 1, length + separatorIdx + 1);
                packets.add(this.decodePacket(packetData));
                payloadIdx = length + separatorIdx + 1;
            }
        } else if (data instanceof byte[]) {
            byte[] byteData = (byte[])data;
            payloadIdx = 0;
            while (payloadIdx < byteData.length) {
                int lengthStartIdx;
                boolean isBinary = byteData[payloadIdx] == 1;
                int lengthEndIdx = lengthStartIdx = payloadIdx + 1;
                while (byteData[lengthEndIdx] != -1) {
                    ++lengthEndIdx;
                }
                StringBuilder lengthString = new StringBuilder();
                for (int l = lengthStartIdx; l < lengthEndIdx; ++l) {
                    char digit = (char)(48 + byteData[l]);
                    lengthString.append(digit);
                }
                int length = Integer.parseInt(lengthString.toString());
                byte[] bufferData = new byte[length];
                System.arraycopy(byteData, lengthEndIdx + 1, bufferData, 0, bufferData.length);
                Packet<?> packet = isBinary ? this.decodePacket(bufferData) : this.decodePacket(new String(bufferData, StandardCharsets.UTF_8));
                packets.add(packet);
                payloadIdx = lengthEndIdx + length + 1;
            }
        }
        for (int i = 0; i < packets.size(); ++i) {
            if (callback.call((Packet)packets.get(i), i, packets.size())) continue;
            return;
        }
    }

    public void encodePayloadAsBinary(List<Packet<?>> packets, Parser.EncodeCallback<Object> callback) {
        if (packets.size() == 0) {
            callback.call(new byte[0]);
            return;
        }
        ArrayList results = new ArrayList(packets.size());
        for (Packet<?> packet : packets) {
            this.encodePacket(packet, true, encodedPacket -> {
                if (encodedPacket instanceof String) {
                    String encodingLength = Integer.toString(((String)encodedPacket).length(), 10);
                    byte[] sizeBuffer = new byte[encodingLength.length() + 2];
                    sizeBuffer[0] = 0;
                    for (int i = 0; i < encodingLength.length(); ++i) {
                        sizeBuffer[i + 1] = (byte)(encodingLength.charAt(i) - 48);
                    }
                    sizeBuffer[sizeBuffer.length - 1] = -1;
                    results.add(ParserV3.concatBuffer(sizeBuffer, ((String)encodedPacket).getBytes(StandardCharsets.UTF_8)));
                } else {
                    String encodingLength = String.valueOf(((byte[])encodedPacket).length);
                    byte[] sizeBuffer = new byte[encodingLength.length() + 2];
                    sizeBuffer[0] = 1;
                    for (int i = 0; i < encodingLength.length(); ++i) {
                        sizeBuffer[i + 1] = (byte)(encodingLength.charAt(i) - 48);
                    }
                    sizeBuffer[sizeBuffer.length - 1] = -1;
                    results.add(ParserV3.concatBuffer(sizeBuffer, (byte[])encodedPacket));
                }
            });
        }
        callback.call(ParserV3.concatBuffer((byte[][])results.toArray((T[])new byte[results.size()][])));
    }

    @Override
    public Packet<?> decodePacket(Object data) {
        if (data == null) {
            return ERROR_PACKET;
        }
        if (data instanceof String) {
            String stringData = (String)data;
            if (stringData.charAt(0) == 'b') {
                Packet packet = new Packet((String)PACKETS_REVERSE.get(Integer.parseInt(String.valueOf(stringData.charAt(1)))));
                packet.data = Base64.getDecoder().decode(stringData.substring(2));
                return packet;
            }
            Packet packet = new Packet((String)PACKETS_REVERSE.get(Integer.parseInt(String.valueOf(stringData.charAt(0)))));
            packet.data = stringData.substring(1);
            return packet;
        }
        if (data instanceof byte[]) {
            byte[] byteData = (byte[])data;
            Packet packet = new Packet((String)PACKETS_REVERSE.get(byteData[0]));
            packet.data = new byte[byteData.length - 1];
            System.arraycopy(byteData, 1, packet.data, 0, ((byte[])packet.data).length);
            return packet;
        }
        throw new IllegalArgumentException("Invalid type for data: " + data.getClass().getSimpleName());
    }

    private static String setLengthHeader(String message) {
        return message.length() + ":" + message;
    }

    private static byte[] concatBuffer(byte[] ... arrays) {
        int length = 0;
        for (byte[] item : arrays) {
            length += item.length;
        }
        byte[] result = new byte[length];
        int idx = 0;
        for (byte[] item : arrays) {
            System.arraycopy(item, 0, result, idx, item.length);
            idx += item.length;
        }
        return result;
    }
}

