/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.converters;

import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.providers.helpers.TypeUtils;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingBatchMessageMetadata;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import org.apache.pulsar.client.api.Messages;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class PulsarBatchMessageConverter
implements MessageConverter {
    public boolean canConvert(Message<?> in, Type target) {
        return in.getMetadata(PulsarIncomingBatchMessageMetadata.class).isPresent() && TypeUtils.getRawTypeIfParameterized((Type)target).equals(Messages.class);
    }

    public Message<?> convert(Message<?> in, Type target) {
        PulsarIncomingBatchMessageMetadata metadata = (PulsarIncomingBatchMessageMetadata)in.getMetadata(PulsarIncomingBatchMessageMetadata.class).orElseThrow(() -> new IllegalStateException("No Pulsar metadata"));
        return in.withPayload(metadata.getMessages());
    }
}

