/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.ack;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.pulsar.PulsarAckHandler;
import io.smallrye.reactive.messaging.pulsar.PulsarConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.pulsar.PulsarIncomingMessage;
import io.smallrye.reactive.messaging.pulsar.transactions.PulsarTransactionMetadata;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageId;

public class PulsarCumulativeAck
implements PulsarAckHandler {
    public static final String STRATEGY_NAME = "cumulative";
    private final Consumer<?> consumer;

    public PulsarCumulativeAck(Consumer<?> consumer) {
        this.consumer = consumer;
    }

    @Override
    public Uni<Void> handle(PulsarIncomingMessage<?> message) {
        MessageId messageId = message.getMessageId();
        message.unwrap().release();
        return Uni.createFrom().completionStage(() -> {
            Optional txnMetadata = message.getMetadata(PulsarTransactionMetadata.class);
            if (txnMetadata.isPresent()) {
                return this.consumer.acknowledgeCumulativeAsync(messageId, ((PulsarTransactionMetadata)txnMetadata.get()).getTransaction());
            }
            return this.consumer.acknowledgeCumulativeAsync(messageId);
        }).emitOn(arg_0 -> message.runOnMessageContext(arg_0));
    }

    @ApplicationScoped
    @Identifier(value="cumulative")
    public static class Factory
    implements PulsarAckHandler.Factory {
        @Override
        public PulsarCumulativeAck create(Consumer<?> consumer, PulsarConnectorIncomingConfiguration config) {
            return new PulsarCumulativeAck(consumer);
        }
    }
}

