/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar;

import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.smallrye.reactive.messaging.pulsar.PulsarMessage;
import io.smallrye.reactive.messaging.pulsar.PulsarOutgoingMessageMetadata;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class PulsarOutgoingMessage<T>
implements PulsarMessage<T>,
ContextAwareMessage<T> {
    private final T payload;
    private final PulsarOutgoingMessageMetadata outgoingMessageMetadata;
    private final Metadata metadata;
    private final Function<Metadata, CompletionStage<Void>> ack;
    private final BiFunction<Throwable, Metadata, CompletionStage<Void>> nack;

    public PulsarOutgoingMessage(T payload, Function<Metadata, CompletionStage<Void>> ack, BiFunction<Throwable, Metadata, CompletionStage<Void>> nack) {
        this(payload, ack, nack, PulsarOutgoingMessageMetadata.builder().build());
    }

    public PulsarOutgoingMessage(T payload, Function<Metadata, CompletionStage<Void>> ack, BiFunction<Throwable, Metadata, CompletionStage<Void>> nack, PulsarOutgoingMessageMetadata outgoingMessageMetadata) {
        this.payload = payload;
        this.ack = ack;
        this.nack = nack;
        this.outgoingMessageMetadata = outgoingMessageMetadata;
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{outgoingMessageMetadata});
    }

    public static <T> PulsarOutgoingMessage<T> from(Message<T> message) {
        return new PulsarOutgoingMessage<Object>(message.getPayload(), message.getAckWithMetadata(), message.getNackWithMetadata(), message.getMetadata(PulsarOutgoingMessageMetadata.class).orElseGet(() -> PulsarOutgoingMessageMetadata.builder().build()));
    }

    public T getPayload() {
        return this.payload;
    }

    @Override
    public String getKey() {
        return this.outgoingMessageMetadata.getKey();
    }

    @Override
    public byte[] getKeyBytes() {
        return this.outgoingMessageMetadata.getKeyBytes();
    }

    @Override
    public boolean hasKey() {
        return this.outgoingMessageMetadata.hasKey();
    }

    @Override
    public byte[] getOrderingKey() {
        return this.outgoingMessageMetadata.getOrderingKey();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.outgoingMessageMetadata.getProperties();
    }

    @Override
    public long getEventTime() {
        return this.outgoingMessageMetadata.getEventTime();
    }

    @Override
    public long getSequenceId() {
        return this.outgoingMessageMetadata.getSequenceId();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Function<Metadata, CompletionStage<Void>> getAckWithMetadata() {
        return this.ack;
    }

    public BiFunction<Throwable, Metadata, CompletionStage<Void>> getNackWithMetadata() {
        return this.nack;
    }
}

