/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar;

import java.util.List;
import java.util.Map;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.transaction.Transaction;

public class OutgoingMessage<T> {
    private Object value;
    private boolean hasKey;
    private String key;
    private byte[] keyBytes;
    private byte[] orderingKey;
    private Map<String, String> properties;
    private List<String> replicatedClusters;
    private boolean replicationDisabled = false;
    private Long eventTime;
    private Long sequenceId;
    private Long deliverAt;
    private Transaction transaction;

    public static <T> OutgoingMessage<T> of(String key, T value) {
        return new OutgoingMessage<T>(key, value);
    }

    public static <T> OutgoingMessage<T> from(Message<T> incoming) {
        OutgoingMessage<Object> outgoing = new OutgoingMessage<Object>(incoming.getValue());
        if (incoming.hasKey()) {
            if (incoming.getKeyBytes() != null) {
                outgoing.withKeyBytes(incoming.getKeyBytes());
            } else {
                outgoing.withKey(incoming.getKey());
            }
        }
        return outgoing;
    }

    public OutgoingMessage(T value) {
        this.value = value;
    }

    public OutgoingMessage(String key, T value) {
        this(value);
        this.withKey(key);
    }

    public boolean hasKey() {
        return this.hasKey;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public OutgoingMessage<T> withKeyBytes(byte[] keyBytes) {
        this.hasKey = keyBytes != null;
        this.keyBytes = keyBytes;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public OutgoingMessage<T> withKey(String key) {
        this.hasKey = key != null;
        this.key = key;
        return this;
    }

    public byte[] getOrderingKey() {
        return this.orderingKey;
    }

    public OutgoingMessage<T> withOrderingKey(byte[] orderingKey) {
        this.orderingKey = orderingKey;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public OutgoingMessage<T> withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public List<String> getReplicatedClusters() {
        return this.replicatedClusters;
    }

    public OutgoingMessage<T> withReplicatedClusters(List<String> replicatedClusters) {
        this.replicatedClusters = replicatedClusters;
        return this;
    }

    public boolean getReplicationDisabled() {
        return this.replicationDisabled;
    }

    public OutgoingMessage<T> withDisabledReplication() {
        this.replicationDisabled = true;
        return this;
    }

    public Long getEventTime() {
        return this.eventTime;
    }

    public OutgoingMessage<T> withEventTime(long eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public Long getSequenceId() {
        return this.sequenceId;
    }

    public OutgoingMessage<T> withSequenceId(long sequenceId) {
        this.sequenceId = sequenceId;
        return this;
    }

    public Long getDeliverAt() {
        return this.deliverAt;
    }

    public OutgoingMessage<T> withDeliverAt(long deliverAt) {
        this.deliverAt = deliverAt;
        return this;
    }

    public T getValue() {
        return (T)this.value;
    }

    public <O> OutgoingMessage<O> withValue(O value) {
        this.value = value;
        return new OutgoingMessage<O>(value);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public OutgoingMessage<T> withTransaction(Transaction txn) {
        this.transaction = txn;
        return this;
    }
}

