/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.pulsar.transactions;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.EmitterType;
import io.smallrye.reactive.messaging.pulsar.transactions.TransactionalEmitter;
import java.time.Duration;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;

@Experimental(value="Experimental API")
public interface PulsarTransactions<T>
extends EmitterType {
    @CheckReturnValue
    public <R> Uni<R> withTransaction(Function<TransactionalEmitter<T>, Uni<R>> var1);

    public <R> Uni<R> withTransaction(Duration var1, Function<TransactionalEmitter<T>, Uni<R>> var2);

    @CheckReturnValue
    public <R> Uni<R> withTransaction(Message<?> var1, Function<TransactionalEmitter<T>, Uni<R>> var2);

    public <R> Uni<R> withTransaction(Duration var1, Message<?> var2, Function<TransactionalEmitter<T>, Uni<R>> var3);

    @CheckReturnValue
    default public Uni<Void> withTransactionAndAck(Message<?> message, Function<TransactionalEmitter<T>, Uni<Void>> work) {
        return this.withTransaction(message, work).onFailure().recoverWithUni(throwable -> Uni.createFrom().completionStage(message.nack(throwable)));
    }

    @CheckReturnValue
    default public Uni<Void> withTransactionAndAck(Duration txnTimeout, Message<?> message, Function<TransactionalEmitter<T>, Uni<Void>> work) {
        return this.withTransaction(txnTimeout, message, work).onFailure().recoverWithUni(throwable -> Uni.createFrom().completionStage(message.nack(throwable)));
    }

    public <M extends Message<? extends T>> void send(TransactionalEmitter<?> var1, M var2);

    public void send(TransactionalEmitter<?> var1, T var2);

    public boolean isTransactionInProgress();
}

