package io.smallrye.reactive.messaging.pulsar.i18n;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.Throwable;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class PulsarExceptions_$bundle implements PulsarExceptions, Serializable {
    private static final long serialVersionUID = 1L;
    protected PulsarExceptions_$bundle() {}
    public static final PulsarExceptions_$bundle INSTANCE = new PulsarExceptions_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String illegalStateUnableToBuildClient$str() {
        return "SRMSG19100: Unable to build Pulsar client";
    }
    @Override
    public final IllegalStateException illegalStateUnableToBuildClient(final Throwable t) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnableToBuildClient$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalStateUnableToBuildConsumer$str() {
        return "SRMSG19101: Unable to build Pulsar consumer";
    }
    @Override
    public final IllegalStateException illegalStateUnableToBuildConsumer(final Throwable t) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnableToBuildConsumer$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateUnableToBuildProducer$str() {
        return "SRMSG19102: Unable to build Pulsar producer";
    }
    @Override
    public final IllegalStateException illegalStateUnableToBuildProducer(final Throwable t) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnableToBuildProducer$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateConsumeWithoutBackPressure$str() {
        return "SRMSG19103: Expecting downstream to consume without back-pressure";
    }
    @Override
    public final IllegalStateException illegalStateConsumeWithoutBackPressure() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateConsumeWithoutBackPressure$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateOnlyOneSubscriber$str() {
        return "SRMSG19104: Only one subscriber allowed";
    }
    @Override
    public final IllegalStateException illegalStateOnlyOneSubscriber() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateOnlyOneSubscriber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
