/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.vertx.core.json.JsonObject;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class JsonHelper {
    public static JsonObject asJsonObject(Config config) {
        JsonObject json = new JsonObject();
        Iterable propertyNames = config.getPropertyNames();
        for (String originalKey : propertyNames) {
            Optional d2;
            String key = originalKey.toLowerCase().replace("_", ".");
            try {
                Optional i = config.getOptionalValue(key, Integer.class);
                if (i.isPresent() && i.get() instanceof Integer) {
                    json.put(key, i.get());
                    continue;
                }
            }
            catch (ClassCastException | IllegalArgumentException i) {
                // empty catch block
            }
            try {
                d2 = config.getOptionalValue(key, Double.class);
                if (d2.isPresent() && d2.get() instanceof Double) {
                    json.put(key, d2.get());
                    continue;
                }
            }
            catch (ClassCastException | IllegalArgumentException d2) {
                // empty catch block
            }
            try {
                Optional s = config.getOptionalValue(key, String.class);
                if (s.isPresent()) {
                    String value = ((String)s.get()).trim();
                    if (value.equalsIgnoreCase("false")) {
                        json.put(key, (Object)false);
                        continue;
                    }
                    if (value.equalsIgnoreCase("true")) {
                        json.put(key, (Object)true);
                        continue;
                    }
                    json.put(key, (Object)value);
                    continue;
                }
            }
            catch (ClassCastException s) {
                // empty catch block
            }
            try {
                d2 = config.getOptionalValue(key, Boolean.class);
                d2.ifPresent(v -> json.put(key, v));
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {}
        }
        return json;
    }
}

