/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.traversal;

import java.io.Serializable;
import overflowdb.traversal.TraversalSugarExt;
import overflowdb.traversal.help.Doc;
import overflowdb.traversal.help.DocSearchPackages;
import overflowdb.traversal.help.Table;
import overflowdb.traversal.help.TraversalHelp;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.MapFactory;
import scala.collection.MapFactory$;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class TraversalSugarExt$
implements Serializable {
    public static final TraversalSugarExt$ MODULE$ = new TraversalSugarExt$();

    private TraversalSugarExt$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TraversalSugarExt$.class);
    }

    public final <A> int hashCode$extension(Iterator $this) {
        return $this.hashCode();
    }

    public final <A> boolean equals$extension(Iterator $this, Object x$0) {
        Object object = x$0;
        if (object instanceof TraversalSugarExt) {
            Iterator iterator = object == null ? null : ((TraversalSugarExt)object).iter();
            Iterator iterator2 = $this;
            Iterator iterator3 = iterator;
            return !(iterator2 != null ? !iterator2.equals(iterator3) : iterator3 != null);
        }
        return false;
    }

    @Doc(info="Execute the traversal and convert the result to a list - shorthand for `toList`")
    public final <A> List<A> l$extension(Iterator $this) {
        return $this.toList();
    }

    @Doc(info="group elements and count how often they appear")
    public final <B, A> Map<B, Object> groupCount$extension(Iterator $this) {
        return this.groupCount$extension($this, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    @Doc(info="group elements by a given transformation function and count how often the results appear")
    public final <B, A> Map<B, Object> groupCount$extension(Iterator $this, Function1<A, B> by) {
        scala.collection.mutable.Map counts = ((scala.collection.mutable.Map)Map$.MODULE$.empty()).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
        $this.foreach((Function1)(JProcedure1 & Serializable)a -> {
            Object b = by.apply(a);
            int newValue = BoxesRunTime.unboxToInt((Object)counts.apply(b)) + 1;
            counts.update(b, (Object)BoxesRunTime.boxToInteger((int)newValue));
        });
        return (Map)counts.to(MapFactory$.MODULE$.toFactory((MapFactory)Predef$.MODULE$.Map()));
    }

    public final <K, A> Map<K, List<A>> groupBy$extension(Iterator $this, Function1<A, K> f) {
        return this.l$extension($this).groupBy(f);
    }

    public final <K, B, A> Map<K, List<B>> groupMap$extension(Iterator $this, Function1<A, K> key, Function1<A, B> f) {
        return this.l$extension($this).groupMap(key, f);
    }

    public final <K, B, A> Map<K, B> groupMapReduce$extension(Iterator $this, Function1<A, K> key, Function1<A, B> f, Function2<B, B, B> reduce) {
        return this.l$extension($this).groupMapReduce(key, f, reduce);
    }

    public final <B, A> LinkedHashSet<B> toSetMutable$extension(Iterator $this) {
        return LinkedHashSet$.MODULE$.from((IterableOnce)$this);
    }

    public final <B, A> Set<B> toSetImmutable$extension(Iterator $this) {
        return $this.toSet();
    }

    @Doc(info="Execute the traversal without returning anything")
    public final <A> void iterate$extension(Iterator $this) {
        while ($this.hasNext()) {
            $this.next();
        }
    }

    public final <A> Iterator<Object> countTrav$extension(Iterator $this) {
        return Iterator$.MODULE$.single((Object)BoxesRunTime.boxToInteger((int)$this.size()));
    }

    public final <A> A head$extension(Iterator $this) {
        return (A)$this.next();
    }

    public final <A> Option<A> headOption$extension(Iterator $this) {
        return $this.nextOption();
    }

    public final <A> A last$extension(Iterator $this) {
        $this.hasNext();
        Object res = $this.next();
        while ($this.hasNext()) {
            res = $this.next();
        }
        return (A)res;
    }

    public final <A> Option<A> lastOption$extension(Iterator $this) {
        if ($this.hasNext()) {
            return Some$.MODULE$.apply(this.last$extension($this));
        }
        return None$.MODULE$;
    }

    @Doc(info="casts all elements to given type")
    public final <B, A> Iterator<B> cast$extension(Iterator $this) {
        return $this;
    }

    @Doc(info="collects all elements of the provided class (beware of type-erasure)")
    public final <B, A> Iterator<B> collectAll$extension(Iterator $this, ClassTag<B> ev) {
        Class clazz = ev.runtimeClass();
        return $this.filter((Function1 & Serializable)x$0 -> clazz.isInstance(x$0));
    }

    @Doc(info="deduplicate elements of this traversal - a.k.a. distinct, unique, ...")
    public final <A> Iterator<A> dedup$extension(Iterator $this) {
        return $this.distinct();
    }

    @Doc(info="deduplicate elements of this traversal by a given function")
    public final <A> Iterator<A> dedupBy$extension(Iterator $this, Function1<A, Object> fun) {
        return $this.distinctBy(fun);
    }

    @Doc(info="sort elements by their natural order")
    public final <B, A> Seq<B> sorted$extension(Iterator $this, Ordering<B> ord) {
        return ((ArraySeq)$this.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ArraySeq$.MODULE$.untagged()))).sorted(ord);
    }

    @Doc(info="sort elements by the value of the given transformation function")
    public final <B, A> Seq<A> sortBy$extension(Iterator $this, Function1<A, B> f, Ordering<B> ord) {
        return (Seq)((SeqOps)$this.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ArraySeq$.MODULE$.untagged()))).sortBy(f, ord);
    }

    @Doc(info="print help/documentation based on the current elementType `A`.")
    public final <B, A> String help$extension(Iterator $this, ClassTag<B> elementType, DocSearchPackages searchPackages, Table.AvailableWidthProvider availableWidthProvider) {
        return new TraversalHelp(searchPackages).forElementSpecificSteps(elementType.runtimeClass(), false, availableWidthProvider);
    }

    @Doc(info="print verbose help/documentation based on the current elementType `A`.")
    public final <B, A> String helpVerbose$extension(Iterator $this, ClassTag<B> elementType, DocSearchPackages searchPackages, Table.AvailableWidthProvider availableWidthProvider) {
        return new TraversalHelp(searchPackages).forElementSpecificSteps(elementType.runtimeClass(), true, availableWidthProvider);
    }
}

