/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.passes;

import com.google.protobuf.GeneratedMessageV3;
import flatgraph.DiffGraphBuilder;
import io.shiftleft.SerializedCpg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import scala.Function0;
import scala.MatchError;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public interface CpgPassBase {
    public static Logger baseLogger$(CpgPassBase $this) {
        return $this.baseLogger();
    }

    default public Logger baseLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public void createAndApply();

    public void createApplySerializeAndStore(SerializedCpg var1, String var2);

    public static String createApplySerializeAndStore$default$2$(CpgPassBase $this) {
        return $this.createApplySerializeAndStore$default$2();
    }

    default public String createApplySerializeAndStore$default$2() {
        return "";
    }

    public static String name$(CpgPassBase $this) {
        return $this.name();
    }

    default public String name() {
        return this.getClass().getName();
    }

    public int runWithBuilder(DiffGraphBuilder var1);

    public static int runWithBuilderLogged$(CpgPassBase $this, DiffGraphBuilder builder) {
        return $this.runWithBuilderLogged(builder);
    }

    default public int runWithBuilderLogged(DiffGraphBuilder builder) {
        this.baseLogger().info(new StringBuilder(15).append("Start of pass: ").append(this.name()).toString());
        long nanoStart = System.nanoTime();
        int size0 = builder.size();
        Try try_ = Try$.MODULE$.apply(() -> this.runWithBuilderLogged$$anonfun$1(builder));
        if (try_ instanceof Success) {
            int nParts = BoxesRunTime.unboxToInt((Object)((Success)try_).value());
            this.baseLogger().info(StringOps$.MODULE$.format$extension("Pass %s completed in %.0f ms.  %d changes generated from %d parts.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToDouble((double)((double)(System.nanoTime() - nanoStart) * 1.0E-6)), BoxesRunTime.boxToInteger((int)(builder.size() - size0)), BoxesRunTime.boxToInteger((int)nParts)})));
            return nParts;
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.baseLogger().warn(StringOps$.MODULE$.format$extension("Pass %s failed in %.0f ms", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), BoxesRunTime.boxToDouble((double)((double)(System.nanoTime() - nanoStart) * 1.0E-6))})), exception);
            return -1;
        }
        throw new MatchError((Object)try_);
    }

    public static String generateOutFileName$(CpgPassBase $this, String prefix, String outName, int index) {
        return $this.generateOutFileName(prefix, outName, index);
    }

    default public String generateOutFileName(String prefix, String outName, int index) {
        String outputName = outName.isEmpty() ? this.getClass().getSimpleName() : outName;
        return new StringBuilder(2).append(prefix).append("_").append(outputName).append("_").append(index).toString();
    }

    public static void store$(CpgPassBase $this, GeneratedMessageV3 overlay, String name, SerializedCpg serializedCpg) {
        $this.store(overlay, name, serializedCpg);
    }

    default public void store(GeneratedMessageV3 overlay, String name, SerializedCpg serializedCpg) {
    }

    public static Object withStartEndTimesLogged$(CpgPassBase $this, Function0 fun) {
        return $this.withStartEndTimesLogged(fun);
    }

    default public <A> A withStartEndTimesLogged(Function0<A> fun) {
        Object object;
        this.baseLogger().info(new StringBuilder(14).append("Running pass: ").append(this.name()).toString());
        long startTime = System.currentTimeMillis();
        try {
            object = fun.apply();
        }
        finally {
            FiniteDuration duration = new package.DurationLong(package$.MODULE$.DurationLong(System.currentTimeMillis() - startTime)).millis().toCoarsest();
            MDC.put((String)"time", (String)duration.toString());
            this.baseLogger().info(new StringBuilder(19).append("Pass ").append(this.name()).append(" completed in ").append(duration).toString());
            MDC.remove((String)"time");
        }
        return (A)object;
    }

    private int runWithBuilderLogged$$anonfun$1(DiffGraphBuilder builder$1) {
        return this.runWithBuilder(builder$1);
    }
}

