/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.cpgloading;

import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;

public class ZipArchive
implements Closeable {
    private final FileSystem zipFileSystem;

    public ZipArchive(String inputFile) {
        this.zipFileSystem = FileSystems.newFileSystem(Paths.get(inputFile, new String[0]), null);
    }

    private Path root() {
        return this.zipFileSystem.getRootDirectories().iterator().next();
    }

    private Seq<Path> walk(Path rootPath) {
        ArrayBuffer entries = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[0]));
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(entries){
            private final ArrayBuffer entries$1;
            {
                this.entries$1 = entries$2;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (attrs.isRegularFile()) {
                    this.entries$1.$plus$eq((Object)file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return entries.toSeq();
    }

    public Seq<Path> entries() {
        return this.walk(this.root());
    }

    public Collection<Path> getFileEntries() {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.entries()).asJava();
    }

    @Override
    public void close() {
        this.zipFileSystem.close();
    }
}

