/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.cpgloading;

import com.google.protobuf.GeneratedMessageV3;
import flatgraph.DNode;
import flatgraph.DNodeOrNode;
import flatgraph.DiffGraphApplier$;
import flatgraph.DiffGraphBuilder;
import flatgraph.GNode;
import flatgraph.GenericDNode;
import flatgraph.GenericDNode$;
import flatgraph.Graph;
import flatgraph.misc.ConversionException;
import flatgraph.misc.Conversions$;
import io.shiftleft.codepropertygraph.cpgloading.ProtoToGraphNodeMappings;
import io.shiftleft.codepropertygraph.cpgloading.ZipArchive;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.Cpg$;
import io.shiftleft.proto.cpg.Cpg;
import io.shiftleft.utils.StringInterner;
import io.shiftleft.utils.StringInterner$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

public final class ProtoCpgLoader$
implements Serializable {
    private static final Logger logger;
    public static final ProtoCpgLoader$ MODULE$;

    private ProtoCpgLoader$() {
    }

    static {
        MODULE$ = new ProtoCpgLoader$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProtoCpgLoader$.class);
    }

    public Cpg loadFromProtoZip(String fileName, Option<Path> storagePath) {
        return (Cpg)this.measureAndReport(() -> this.loadFromProtoZip$$anonfun$1(fileName, storagePath));
    }

    public Cpg loadFromListOfProtos(Function0<Iterator<Cpg.CpgStruct>> protoCpgs, Option<Path> storagePath) {
        StringInterner interner = StringInterner$.MODULE$.makeStrongInterner(StringInterner$.MODULE$.makeStrongInterner$default$1(), StringInterner$.MODULE$.makeStrongInterner$default$2());
        ProtoToGraphNodeMappings protoToGraphNodeMappings = new ProtoToGraphNodeMappings();
        Cpg cpg = this.openOrCreateCpg(storagePath);
        ((IterableOnceOps)protoCpgs.apply()).foreach((Function1)(JProcedure1 & Serializable)cpgProto -> MODULE$.addNodesRaw(MODULE$.nodesIter((Cpg.CpgStruct)cpgProto), cpg.graph(), protoToGraphNodeMappings));
        DiffGraphBuilder diffGraph = Cpg$.MODULE$.newDiffGraphBuilder();
        ((IterableOnceOps)protoCpgs.apply()).foreach((Function1)(JProcedure1 & Serializable)protoCpg -> {
            this.nodesIter((Cpg.CpgStruct)protoCpg).foreach((Function1)(JProcedure1 & Serializable)protoNode -> {
                LazyRef lazyRef = new LazyRef();
                long protoNodeId = protoNode.getKey();
                CollectionConverters$.MODULE$.IteratorHasAsScala(protoNode.getPropertyList().iterator()).asScala().foreach((Function1 & Serializable)protoProperty -> diffGraph.setNodeProperty(this.gNode$1(lazyRef, protoToGraphNodeMappings, (Cpg.CpgStruct.Node)protoNode, protoNodeId), protoProperty.getName().name(), this.extractPropertyValue(protoProperty.getValue(), interner)));
            });
            CollectionConverters$.MODULE$.IteratorHasAsScala(protoCpg.getEdgeList().iterator()).asScala().foreach((Function1 & Serializable)protoEdge -> {
                SeqOps seqOps;
                List list = ((List)new .colon.colon((Object)BoxesRunTime.boxToLong((long)protoEdge.getSrc()), (List)new .colon.colon((Object)BoxesRunTime.boxToLong((long)protoEdge.getDst()), (List)Nil$.MODULE$))).map((Function1 & Serializable)protoNodeId -> protoToGraphNodeMappings.findGNode(BoxesRunTime.unboxToLong((Object)protoNodeId)));
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 2) == 0) {
                    Option option = (Option)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    Option option2 = (Option)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                    if (option instanceof Some) {
                        GNode srcNode = (GNode)((Some)option).value();
                        if (option2 instanceof Some) {
                            GNode dstNode = (GNode)((Some)option2).value();
                            return diffGraph.addEdge((DNodeOrNode)srcNode, (DNodeOrNode)dstNode, protoEdge.getType().name(), MODULE$.extractEdgePropertyValue((Cpg.CpgStruct.Edge)protoEdge, interner));
                        }
                    }
                }
                return BoxedUnit.UNIT;
            });
        });
        DiffGraphApplier$.MODULE$.applyDiff(cpg.graph(), diffGraph, DiffGraphApplier$.MODULE$.applyDiff$default$3());
        return cpg;
    }

    public Cpg loadFromListOfProtos(java.util.List<Cpg.CpgStruct> cpgs, Option<Path> storagePath) {
        return this.loadFromListOfProtos((Function0<Iterator<Cpg.CpgStruct>>)(Function0 & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala(cpgs).asScala().iterator(), storagePath);
    }

    private Cpg openOrCreateCpg(Option<Path> storagePath) {
        Option<Path> option = storagePath;
        if (option instanceof Some) {
            Path storagePath2 = (Path)((Some)option).value();
            return Cpg$.MODULE$.withStorage(storagePath2, Cpg$.MODULE$.withStorage$default$2());
        }
        if (None$.MODULE$.equals(option)) {
            return Cpg$.MODULE$.empty();
        }
        throw new MatchError(option);
    }

    private Iterator<Cpg.CpgStruct.Node> nodesIter(Cpg.CpgStruct protoCpg) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(protoCpg.getNodeList().iterator()).asScala();
    }

    private void addNodesRaw(Iterator<Cpg.CpgStruct.Node> protoNodes, Graph graph, ProtoToGraphNodeMappings protoToGraphNodeMappings) {
        DiffGraphBuilder diffGraph = Cpg$.MODULE$.newDiffGraphBuilder();
        protoNodes.filterNot((Function1 & Serializable)protoNode -> protoToGraphNodeMappings.contains((Cpg.CpgStruct.Node)protoNode)).foreach((Function1)(JProcedure1 & Serializable)protoNode -> {
            String label = protoNode.getType().name();
            Option option = graph.schema().getNodeKindByLabelMaybe(label);
            if (None$.MODULE$.equals(option)) {
                logger.warn(new StringBuilder(60).append("nodeKind for label=`").append(label).append("` not found - is this a valid proto cpg?").toString());
                return;
            }
            if (option instanceof Some) {
                int nodeKind = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                GenericDNode newNode = new GenericDNode(Conversions$.MODULE$.toShortSafely(graph.schema().getNodeKindByLabel(protoNode.getType().name())), GenericDNode$.MODULE$.$lessinit$greater$default$2());
                diffGraph.addNode((DNode)newNode);
                protoToGraphNodeMappings.add((Cpg.CpgStruct.Node)protoNode, (DNode)newNode);
                return;
            }
            throw new MatchError((Object)option);
        });
        DiffGraphApplier$.MODULE$.applyDiff(graph, diffGraph, DiffGraphApplier$.MODULE$.applyDiff$default$3());
    }

    private Object extractPropertyValue(Cpg.PropertyValue value, StringInterner interner) {
        Cpg.PropertyValue$.ValueCase valueCase = value.getValueCase();
        Cpg.PropertyValue$.ValueCase valueCase2 = Cpg.PropertyValue$.ValueCase.INT_VALUE;
        Cpg.PropertyValue$.ValueCase valueCase3 = valueCase;
        if (!(valueCase2 != null ? !valueCase2.equals(valueCase3) : valueCase3 != null)) {
            return BoxesRunTime.boxToInteger((int)value.getIntValue());
        }
        Cpg.PropertyValue$.ValueCase valueCase4 = Cpg.PropertyValue$.ValueCase.BOOL_VALUE;
        Cpg.PropertyValue$.ValueCase valueCase5 = valueCase;
        if (!(valueCase4 != null ? !valueCase4.equals(valueCase5) : valueCase5 != null)) {
            return BoxesRunTime.boxToBoolean((boolean)value.getBoolValue());
        }
        Cpg.PropertyValue$.ValueCase valueCase6 = Cpg.PropertyValue$.ValueCase.STRING_VALUE;
        Cpg.PropertyValue$.ValueCase valueCase7 = valueCase;
        if (!(valueCase6 != null ? !valueCase6.equals(valueCase7) : valueCase7 != null)) {
            return interner.intern(value.getStringValue());
        }
        Cpg.PropertyValue$.ValueCase valueCase8 = Cpg.PropertyValue$.ValueCase.STRING_LIST;
        Cpg.PropertyValue$.ValueCase valueCase9 = valueCase;
        if (!(valueCase8 != null ? !valueCase8.equals(valueCase9) : valueCase9 != null)) {
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)value.getStringList().getValuesList()).asScala().map((Function1 & Serializable)s -> interner.intern((String)s))).toList();
        }
        Cpg.PropertyValue$.ValueCase valueCase10 = Cpg.PropertyValue$.ValueCase.VALUE_NOT_SET;
        Cpg.PropertyValue$.ValueCase valueCase11 = valueCase;
        if (!(valueCase10 != null ? !valueCase10.equals(valueCase11) : valueCase11 != null)) {
            return null;
        }
        throw new RuntimeException(new StringBuilder(34).append("Error: unsupported property case: ").append(value.getValueCase().name()).toString());
    }

    private Object extractEdgePropertyValue(Cpg.CpgStruct.Edge protoEdge, StringInterner interner) {
        Buffer protoProperties = CollectionConverters$.MODULE$.ListHasAsScala(protoEdge.getPropertyList()).asScala();
        if (protoProperties.isEmpty()) {
            return null;
        }
        if (protoProperties.size() == 1) {
            return this.extractPropertyValue(((Cpg.CpgStruct$.Edge$.Property)protoProperties.head()).getValue(), interner);
        }
        throw new IllegalArgumentException(new StringBuilder(89).append("flatgraph only supports zero or one edge properties, but the given edge has ").append(protoProperties.size()).append(" properties: ").append(protoProperties).toString());
    }

    public Try<Iterator<Cpg.CpgOverlay>> loadOverlays(String fileName) {
        return this.loadOverlays(fileName, (Function1 & Serializable)x$0 -> Cpg.CpgOverlay.parseFrom((InputStream)x$0));
    }

    private <T extends GeneratedMessageV3> Try<Iterator<T>> loadOverlays(String fileName, Function1<InputStream, T> f) {
        return Using$.MODULE$.apply(() -> ProtoCpgLoader$.loadOverlays$$anonfun$2(fileName), (Function1 & Serializable)zip -> ((IterableOnce)((IterableOps)zip.entries().sortWith((Function2 & Serializable)(a, b) -> MODULE$.compareOverlayPath((Path)a, (Path)b))).map((Function1 & Serializable)path -> {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            return (GeneratedMessageV3)f.apply((Object)is);
        })).iterator(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private boolean compareOverlayPath(Path a, Path b) {
        String[] file1Split = a.toString().replace("/", "").split("_");
        String[] file2Split = b.toString().replace("/", "").split("_");
        if (file1Split.length < 2 || file2Split.length < 2) {
            return StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(a.toString()), b.toString());
        }
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(file1Split[0])) < StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(file2Split[0]));
    }

    private <A> A measureAndReport(Function0<A> f) {
        long start = System.currentTimeMillis();
        Object result = f.apply();
        logger.info(new StringBuilder(32).append("CPG construction finished in ").append(System.currentTimeMillis() - start).append("ms.").toString());
        return (A)result;
    }

    private final Iterator cpgProtos$1(Using.Manager use$1, String fileName$1) {
        return ((ZipArchive)use$1.apply((Object)new ZipArchive(fileName$1), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$)).entries().iterator().map((Function1 & Serializable)entry -> {
            InputStream inputStream = (InputStream)use$1.apply((Object)Files.newInputStream(entry, new OpenOption[0]), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return Cpg.CpgStruct.parseFrom((InputStream)inputStream);
        });
    }

    private final Cpg loadFromProtoZip$$anonfun$1(String fileName$2, Option storagePath$1) {
        return (Cpg)Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> this.loadFromListOfProtos((Function0<Iterator<Cpg.CpgStruct>>)(Function0 & Serializable)() -> this.cpgProtos$1((Using.Manager)use, fileName$2), (Option<Path>)storagePath$1)).get();
    }

    private static final GNode gNode$lzyINIT1$1$$anonfun$1(long protoNodeId$2) {
        throw new ConversionException(new StringBuilder(43).append("node with proto node id=").append(protoNodeId$2).append(" not found in graph").toString());
    }

    private final GNode gNode$lzyINIT1$1(LazyRef gNode$lzy1$1, ProtoToGraphNodeMappings protoToGraphNodeMappings$2, Cpg.CpgStruct.Node protoNode$1, long protoNodeId$1) {
        GNode gNode;
        LazyRef lazyRef = gNode$lzy1$1;
        synchronized (lazyRef) {
            gNode = (GNode)(gNode$lzy1$1.initialized() ? gNode$lzy1$1.value() : gNode$lzy1$1.initialize((Object)((GNode)protoToGraphNodeMappings$2.findGNode(protoNode$1).getOrElse(() -> ProtoCpgLoader$.gNode$lzyINIT1$1$$anonfun$1(protoNodeId$1)))));
        }
        return gNode;
    }

    private final GNode gNode$1(LazyRef gNode$lzy1$2, ProtoToGraphNodeMappings protoToGraphNodeMappings$5, Cpg.CpgStruct.Node protoNode$2, long protoNodeId$3) {
        return (GNode)(gNode$lzy1$2.initialized() ? gNode$lzy1$2.value() : this.gNode$lzyINIT1$1(gNode$lzy1$2, protoToGraphNodeMappings$5, protoNode$2, protoNodeId$3));
    }

    private static final ZipArchive loadOverlays$$anonfun$2(String fileName$4) {
        return new ZipArchive(fileName$4);
    }
}

