/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.codepropertygraph.cpgloading;

import flatgraph.convert.Convert$;
import io.shiftleft.codepropertygraph.cpgloading.ProtoCpgLoader$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.Cpg$;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Using;
import scala.util.Using$;

public final class CpgLoader$
implements Serializable {
    private static final Logger logger;
    public static final CpgLoader$ MODULE$;

    private CpgLoader$() {
    }

    static {
        MODULE$ = new CpgLoader$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CpgLoader$.class);
    }

    public Cpg load(String filename) {
        return this.load(Paths.get(filename, new String[0]));
    }

    public Cpg load(String from, String persistTo) {
        return this.load(Paths.get(from, new String[0]), Paths.get(persistTo, new String[0]));
    }

    public Cpg load(Path path) {
        Path absolutePath = path.toAbsolutePath();
        if (!Files.exists(absolutePath, new LinkOption[0])) {
            throw new FileNotFoundException(new StringBuilder(32).append("given input file ").append(absolutePath).append(" does not exist").toString());
        }
        if (this.isProtoFormat(absolutePath)) {
            return this.load(path, absolutePath.resolveSibling(new StringBuilder(3).append(path.getFileName()).append(".fg").toString()));
        }
        if (this.isOverflowDbFormat(absolutePath)) {
            return this.load(absolutePath, path.resolveSibling(new StringBuilder(3).append(path.getFileName()).append(".fg").toString()));
        }
        return Cpg$.MODULE$.withStorage(absolutePath, Cpg$.MODULE$.withStorage$default$2());
    }

    public Cpg load(Path from, Path persistTo) {
        Path absolutePath = from.toAbsolutePath();
        Path path = persistTo;
        Path path2 = from;
        if (path == null ? path2 != null : !((Object)path).equals(path2)) {
            Files.deleteIfExists(persistTo);
        }
        if (!Files.exists(absolutePath, new LinkOption[0])) {
            throw new FileNotFoundException(new StringBuilder(32).append("given input file ").append(absolutePath).append(" does not exist").toString());
        }
        if (this.isProtoFormat(absolutePath)) {
            logger.debug(new StringBuilder(55).append("Converting ").append(from).append(" from proto cpg into new flatgraph storage: ").append(persistTo).toString());
            return ProtoCpgLoader$.MODULE$.loadFromProtoZip(absolutePath.toString(), (Option<Path>)Option$.MODULE$.apply((Object)persistTo));
        }
        if (this.isOverflowDbFormat(absolutePath)) {
            return this.loadFromOverflowDb(absolutePath, persistTo);
        }
        if (this.isFlatgraphFormat(absolutePath)) {
            Files.copy(absolutePath, persistTo, new CopyOption[0]);
            return Cpg$.MODULE$.withStorage(persistTo, Cpg$.MODULE$.withStorage$default$2());
        }
        throw new AssertionError((Object)"unknown file format - we probed the first bytes but it didn't look like one of our known formats (proto.zip, flatgraph, overflowdb)");
    }

    public boolean isProtoFormat(Path path) {
        return this.probeFirstBytes(path, "PK");
    }

    public boolean isProtoFormat(String filename) {
        return this.isProtoFormat(Paths.get(filename, new String[0]));
    }

    public boolean isOverflowDbFormat(Path path) {
        return this.probeFirstBytes(path, "H:2");
    }

    public boolean isFlatgraphFormat(Path path) {
        return this.probeFirstBytes(path, "FLT GRPH");
    }

    public Cpg loadFromOverflowDb(Path path, Path persistTo) {
        logger.info(new StringBuilder(54).append("Converting ").append(path).append(" from overflowdb to new flatgraph storage: ").append(persistTo).toString());
        Convert$.MODULE$.convertOdbToFlatgraph(path, persistTo, Convert$.MODULE$.convertOdbToFlatgraph$default$3());
        return Cpg$.MODULE$.withStorage(persistTo, Cpg$.MODULE$.withStorage$default$2());
    }

    public boolean isLegacyCpg(String filename) {
        return this.isProtoFormat(Paths.get(filename, new String[0]));
    }

    public boolean isLegacyCpg(Path path) {
        return this.isProtoFormat(path);
    }

    private boolean probeFirstBytes(Path path, String probeFor) {
        return BoxesRunTime.unboxToBoolean((Object)Using$.MODULE$.apply(() -> CpgLoader$.probeFirstBytes$$anonfun$1(path), (Function1 & Serializable)is -> {
            byte[] buffer = new byte[StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(probeFor))];
            is.read(buffer);
            String string = new String(buffer, StandardCharsets.UTF_8);
            String string2 = probeFor;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).getOrElse(CpgLoader$::probeFirstBytes$$anonfun$3));
    }

    private static final InputStream probeFirstBytes$$anonfun$1(Path path$1) {
        return Files.newInputStream(path$1, new OpenOption[0]);
    }

    private static final boolean probeFirstBytes$$anonfun$3() {
        return false;
    }
}

