/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.metadata;

import io.netty.buffer.ByteBuf;
import io.rsocket.metadata.CompositeMetadata;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class TaggingMetadata
implements Iterable<String>,
CompositeMetadata.Entry {
    private static int TAG_LENGTH_MAX = 255;
    private String mimeType;
    private ByteBuf content;

    public TaggingMetadata(String mimeType, ByteBuf content) {
        this.mimeType = mimeType;
        this.content = content;
    }

    public Stream<String> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 273), false);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return TaggingMetadata.this.content.readerIndex() < TaggingMetadata.this.content.capacity();
            }

            @Override
            public String next() {
                int tagLength = TAG_LENGTH_MAX & TaggingMetadata.this.content.readByte();
                if (tagLength > 0) {
                    return TaggingMetadata.this.content.readSlice(tagLength).toString(StandardCharsets.UTF_8);
                }
                return "";
            }
        };
    }

    @Override
    public ByteBuf getContent() {
        return this.content;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }
}

