/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import reactor.util.annotation.Nullable;

public class LeaseFrameCodec {
    public static ByteBuf encode(ByteBufAllocator allocator, int ttl, int numRequests, @Nullable ByteBuf metadata) {
        boolean addMetadata;
        boolean hasMetadata = metadata != null;
        int flags = 0;
        if (hasMetadata) {
            flags |= 0x100;
        }
        ByteBuf header = FrameHeaderCodec.encodeStreamZero(allocator, FrameType.LEASE, flags).writeInt(ttl).writeInt(numRequests);
        if (hasMetadata) {
            if (metadata.isReadable()) {
                addMetadata = true;
            } else {
                metadata.release();
                addMetadata = false;
            }
        } else {
            addMetadata = false;
        }
        if (addMetadata) {
            return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{header, metadata});
        }
        return header;
    }

    public static int ttl(ByteBuf byteBuf) {
        FrameHeaderCodec.ensureFrameType(FrameType.LEASE, byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderCodec.size());
        int ttl = byteBuf.readInt();
        byteBuf.resetReaderIndex();
        return ttl;
    }

    public static int numRequests(ByteBuf byteBuf) {
        FrameHeaderCodec.ensureFrameType(FrameType.LEASE, byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderCodec.size() + 4);
        int numRequests = byteBuf.readInt();
        byteBuf.resetReaderIndex();
        return numRequests;
    }

    @Nullable
    public static ByteBuf metadata(ByteBuf byteBuf) {
        FrameHeaderCodec.ensureFrameType(FrameType.LEASE, byteBuf);
        if (FrameHeaderCodec.hasMetadata(byteBuf)) {
            byteBuf.markReaderIndex();
            byteBuf.skipBytes(FrameHeaderCodec.size() + 8);
            ByteBuf metadata = byteBuf.slice();
            byteBuf.resetReaderIndex();
            return metadata;
        }
        return null;
    }
}

