/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCounted;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketClient;
import io.rsocket.core.ReconnectMono;
import io.rsocket.core.ResolvingOperator;
import io.rsocket.frame.FrameType;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CorePublisher;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Sinks;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

class DefaultRSocketClient
extends ResolvingOperator<RSocket>
implements CoreSubscriber<RSocket>,
CorePublisher<RSocket>,
RSocketClient {
    static final Consumer<ReferenceCounted> DISCARD_ELEMENTS_CONSUMER = referenceCounted -> {
        if (referenceCounted.refCnt() > 0) {
            try {
                referenceCounted.release();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    };
    static final Object ON_DISCARD_KEY;
    final Mono<RSocket> source;
    final Sinks.Empty<Void> onDisposeSink;
    volatile Subscription s;
    static final AtomicReferenceFieldUpdater<DefaultRSocketClient, Subscription> S;

    DefaultRSocketClient(Mono<RSocket> source) {
        this.source = this.unwrapReconnectMono(source);
        this.onDisposeSink = Sinks.empty();
    }

    private Mono<RSocket> unwrapReconnectMono(Mono<RSocket> source) {
        return source instanceof ReconnectMono ? ((ReconnectMono)source).getSource() : source;
    }

    @Override
    public Mono<Void> onClose() {
        return this.onDisposeSink.asMono();
    }

    @Override
    public Mono<RSocket> source() {
        return Mono.fromDirect((Publisher)this);
    }

    @Override
    public Mono<Void> fireAndForget(Mono<Payload> payloadMono) {
        return new RSocketClientMonoOperator(this, FrameType.REQUEST_FNF, payloadMono);
    }

    @Override
    public Mono<Payload> requestResponse(Mono<Payload> payloadMono) {
        return new RSocketClientMonoOperator(this, FrameType.REQUEST_RESPONSE, payloadMono);
    }

    @Override
    public Flux<Payload> requestStream(Mono<Payload> payloadMono) {
        return new RSocketClientFluxOperator<Mono<Payload>>(this, FrameType.REQUEST_STREAM, payloadMono);
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return new RSocketClientFluxOperator<Publisher<Payload>>(this, FrameType.REQUEST_CHANNEL, payloads);
    }

    @Override
    public Mono<Void> metadataPush(Mono<Payload> payloadMono) {
        return new RSocketClientMonoOperator(this, FrameType.METADATA_PUSH, payloadMono);
    }

    public void subscribe(CoreSubscriber<? super RSocket> actual) {
        ResolvingOperator.MonoDeferredResolutionOperator<? super RSocket> inner = new ResolvingOperator.MonoDeferredResolutionOperator<RSocket>(this, actual);
        actual.onSubscribe(inner);
        this.observe(inner);
    }

    public void subscribe(Subscriber<? super RSocket> s) {
        this.subscribe((CoreSubscriber<? super RSocket>)Operators.toCoreSubscriber(s));
    }

    public void onSubscribe(Subscription s) {
        if (Operators.setOnce(S, (Object)this, (Subscription)s)) {
            s.request(Long.MAX_VALUE);
        }
    }

    public void onComplete() {
        Subscription s = this.s;
        RSocket value = (RSocket)this.value;
        if (s == Operators.cancelledSubscription() || !S.compareAndSet(this, s, null)) {
            this.doFinally();
            return;
        }
        if (value == null) {
            this.terminate(new IllegalStateException("Source completed empty"));
        } else {
            this.complete(value);
        }
    }

    public void onError(Throwable t) {
        Subscription s = this.s;
        if (s == Operators.cancelledSubscription() || S.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
            this.doFinally();
            Operators.onErrorDropped((Throwable)t, (Context)Context.empty());
            return;
        }
        this.doFinally();
        this.terminate(t);
    }

    public void onNext(RSocket value) {
        if (this.s == Operators.cancelledSubscription()) {
            this.doOnValueExpired(value);
            return;
        }
        this.value = value;
        this.doFinally();
    }

    @Override
    protected void doSubscribe() {
        this.source.subscribe((CoreSubscriber)this);
    }

    @Override
    protected void doOnValueResolved(RSocket value) {
        value.onClose().subscribe(null, t -> this.invalidate(), this::invalidate);
    }

    @Override
    protected void doOnValueExpired(RSocket value) {
        value.dispose();
    }

    @Override
    protected void doOnDispose() {
        Operators.terminate(S, (Object)this);
        RSocket value = (RSocket)this.value;
        if (value != null) {
            value.onClose().subscribe(null, arg_0 -> this.onDisposeSink.tryEmitError(arg_0), () -> this.onDisposeSink.tryEmitEmpty());
        } else {
            this.onDisposeSink.tryEmitEmpty();
        }
    }

    static {
        Context discardAwareContext = Operators.enableOnDiscard(null, DISCARD_ELEMENTS_CONSUMER);
        ON_DISCARD_KEY = ((Map.Entry)discardAwareContext.stream().findFirst().get()).getKey();
        S = AtomicReferenceFieldUpdater.newUpdater(DefaultRSocketClient.class, Subscription.class, "s");
    }

    static class RSocketClientFluxOperator<ST extends Publisher<Payload>>
    extends Flux<Payload> {
        final DefaultRSocketClient parent;
        final FrameType requestType;
        final ST source;

        public RSocketClientFluxOperator(DefaultRSocketClient parent, FrameType requestType, ST source) {
            this.parent = parent;
            this.requestType = requestType;
            this.source = source;
        }

        public void subscribe(CoreSubscriber<? super Payload> actual) {
            if (this.requestType == FrameType.REQUEST_CHANNEL) {
                RequestChannelInner inner = new RequestChannelInner(this.parent, (Publisher<Payload>)this.source, actual, this.requestType);
                actual.onSubscribe((Subscription)inner);
                this.parent.observe(inner);
            } else {
                this.source.subscribe(new FlatMapMain<Payload>(this.parent, actual, this.requestType));
            }
        }
    }

    static class RSocketClientMonoOperator<T>
    extends MonoOperator<Payload, T> {
        final DefaultRSocketClient parent;
        final FrameType requestType;

        public RSocketClientMonoOperator(DefaultRSocketClient parent, FrameType requestType, Mono<Payload> source) {
            super(source);
            this.parent = parent;
            this.requestType = requestType;
        }

        public void subscribe(CoreSubscriber<? super T> actual) {
            this.source.subscribe(new FlatMapMain<T>(this.parent, actual, this.requestType));
        }
    }

    static final class RequestChannelInner
    extends ResolvingOperator.DeferredResolution<Payload, RSocket> {
        final FrameType interactionType;
        final Publisher<Payload> upstream;

        RequestChannelInner(DefaultRSocketClient parent, Publisher<Payload> upstream, CoreSubscriber<? super Payload> actual, FrameType interactionType) {
            super(parent, actual);
            this.upstream = upstream;
            this.interactionType = interactionType;
        }

        @Override
        public void accept(RSocket rSocket, Throwable t) {
            if (this.isCancelled()) {
                return;
            }
            if (t != null) {
                this.onError(t);
                return;
            }
            if (this.interactionType != FrameType.REQUEST_CHANNEL) {
                this.onError(new IllegalStateException("Should never happen"));
                return;
            }
            Flux<Payload> source = rSocket.requestChannel(this.upstream);
            source.subscribe((CoreSubscriber)this);
        }
    }

    static final class FlattingInner<T>
    extends ResolvingOperator.DeferredResolution<T, RSocket> {
        final FlatMapMain<T> main;
        final FrameType interactionType;
        volatile Payload payload;
        static final AtomicReferenceFieldUpdater<FlattingInner, Payload> PAYLOAD = AtomicReferenceFieldUpdater.newUpdater(FlattingInner.class, Payload.class, "payload");

        FlattingInner(DefaultRSocketClient parent, FlatMapMain<T> main, CoreSubscriber<? super T> actual, FrameType interactionType) {
            super(parent, actual);
            this.main = main;
            this.interactionType = interactionType;
        }

        @Override
        public void accept(RSocket rSocket, Throwable t) {
            Object source;
            if (this.isCancelled()) {
                return;
            }
            Payload payload = PAYLOAD.getAndSet(this, null);
            if (payload == null) {
                return;
            }
            if (t != null) {
                if (payload.refCnt() > 0) {
                    try {
                        payload.release();
                    }
                    catch (IllegalReferenceCountException illegalReferenceCountException) {
                        // empty catch block
                    }
                }
                this.onError(t);
                return;
            }
            switch (this.interactionType) {
                case REQUEST_FNF: {
                    source = rSocket.fireAndForget(payload);
                    break;
                }
                case REQUEST_RESPONSE: {
                    source = rSocket.requestResponse(payload);
                    break;
                }
                case REQUEST_STREAM: {
                    source = rSocket.requestStream(payload);
                    break;
                }
                case METADATA_PUSH: {
                    source = rSocket.metadataPush(payload);
                    break;
                }
                default: {
                    this.onError(new IllegalStateException("Should never happen"));
                    return;
                }
            }
            source.subscribe((CoreSubscriber)this);
        }

        @Override
        public void request(long n) {
            super.request(n);
            this.main.request(n);
        }

        @Override
        public void cancel() {
            long state = REQUESTED.getAndSet(this, Long.MIN_VALUE);
            if (state == Long.MIN_VALUE) {
                return;
            }
            this.main.cancel();
            if (state == -1L) {
                this.s.cancel();
            } else {
                this.parent.remove(this);
                Payload payload = PAYLOAD.getAndSet(this, null);
                if (payload != null) {
                    payload.release();
                }
            }
        }
    }

    static final class FlatMapMain<R>
    implements CoreSubscriber<Payload>,
    Context,
    Scannable {
        final DefaultRSocketClient parent;
        final CoreSubscriber<? super R> actual;
        final FlattingInner<R> second;
        Subscription s;
        boolean done;

        FlatMapMain(DefaultRSocketClient parent, CoreSubscriber<? super R> actual, FrameType requestType) {
            this.parent = parent;
            this.actual = actual;
            this.second = new FlattingInner<R>(parent, this, actual, requestType);
        }

        public Context currentContext() {
            return this;
        }

        public Stream<? extends Scannable> inners() {
            return Stream.of(this.second);
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.second.isCancelled();
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe(this.second);
            }
        }

        public void onNext(Payload payload) {
            if (this.done) {
                if (payload.refCnt() > 0) {
                    try {
                        payload.release();
                    }
                    catch (IllegalReferenceCountException illegalReferenceCountException) {
                        // empty catch block
                    }
                }
                return;
            }
            this.done = true;
            FlattingInner<R> inner = this.second;
            if (inner.isCancelled()) {
                if (payload.refCnt() > 0) {
                    try {
                        payload.release();
                    }
                    catch (IllegalReferenceCountException illegalReferenceCountException) {
                        // empty catch block
                    }
                }
                return;
            }
            inner.payload = payload;
            if (inner.isCancelled()) {
                if (FlattingInner.PAYLOAD.compareAndSet(inner, payload, null) && payload.refCnt() > 0) {
                    try {
                        payload.release();
                    }
                    catch (IllegalReferenceCountException illegalReferenceCountException) {
                        // empty catch block
                    }
                }
                return;
            }
            this.parent.observe(inner);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped((Throwable)t, (Context)this.actual.currentContext());
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        void request(long n) {
            this.s.request(n);
        }

        void cancel() {
            this.s.cancel();
        }

        public <K> K get(Object key) {
            if (key == ON_DISCARD_KEY) {
                return (K)DISCARD_ELEMENTS_CONSUMER;
            }
            return (K)this.actual.currentContext().get(key);
        }

        public boolean hasKey(Object key) {
            if (key == ON_DISCARD_KEY) {
                return true;
            }
            return this.actual.currentContext().hasKey(key);
        }

        public Context put(Object key, Object value) {
            return this.actual.currentContext().put(ON_DISCARD_KEY, DISCARD_ELEMENTS_CONSUMER).put(key, value);
        }

        public Context delete(Object key) {
            return this.actual.currentContext().put(ON_DISCARD_KEY, DISCARD_ELEMENTS_CONSUMER).delete(key);
        }

        public int size() {
            return this.actual.currentContext().size() + 1;
        }

        public Stream<Map.Entry<Object, Object>> stream() {
            return Stream.concat(Stream.of(new AbstractMap.SimpleImmutableEntry<Object, Consumer<ReferenceCounted>>(ON_DISCARD_KEY, DISCARD_ELEMENTS_CONSUMER)), this.actual.currentContext().stream());
        }
    }
}

