/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.config.WebSocketsClientRuntimeConfig;
import io.quarkus.websockets.next.runtime.config.WebSocketsServerRuntimeConfig;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.ErrorCountingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.ErrorInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.MetricsConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.MetricsForwardingWebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.MetricsSendingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.SendingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetryConstants;
import io.quarkus.websockets.next.runtime.telemetry.TelemetryWebSocketEndpointContext;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProviderBuilder;
import java.util.function.Consumer;
import java.util.function.Function;

public final class MetricsBuilderCustomizer
implements Consumer<WebSocketTelemetryProviderBuilder> {
    private static final String URI_TAG_KEY = "uri";
    private final MeterRegistry meterRegistry;
    private final boolean serverMetricsEnabled;
    private final boolean clientMetricsEnabled;

    MetricsBuilderCustomizer(MeterRegistry meterRegistry, WebSocketsServerRuntimeConfig serverRuntimeConfig, WebSocketsClientRuntimeConfig clientRuntimeConfig) {
        this.serverMetricsEnabled = serverRuntimeConfig.telemetry().metricsEnabled();
        this.clientMetricsEnabled = clientRuntimeConfig.telemetry().metricsEnabled();
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void accept(WebSocketTelemetryProviderBuilder builder) {
        if (this.clientMetricsEnabled) {
            this.addClientMetricsSupport(builder);
        }
        if (this.serverMetricsEnabled) {
            this.addServerMetricsSupport(builder);
        }
    }

    private void addServerMetricsSupport(WebSocketTelemetryProviderBuilder builder) {
        final Meter.MeterProvider messagesCounter = Counter.builder((String)"quarkus.websockets.server.count").description("Number of messages sent and received by server endpoints.").withRegistry(this.meterRegistry);
        final Meter.MeterProvider bytesCounter = Counter.builder((String)"quarkus.websockets.server.bytes").description("Number of bytes sent and received by server endpoints.").withRegistry(this.meterRegistry);
        builder.serverEndpointDecorator(new Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint>(){
            private final Meter.MeterProvider<Counter> closedConnectionCounter;
            {
                this.closedConnectionCounter = Counter.builder((String)"quarkus.websockets.server.connections.closed").description("Number of closed server WebSocket connections.").withRegistry(MetricsBuilderCustomizer.this.meterRegistry);
            }

            @Override
            public WebSocketEndpoint apply(TelemetryWebSocketEndpointContext ctx) {
                return new MetricsForwardingWebSocketEndpoint(ctx.endpoint(), MetricsBuilderCustomizer.createCounter((Meter.MeterProvider<Counter>)messagesCounter, TelemetryConstants.Direction.INBOUND, ctx.path()), MetricsBuilderCustomizer.createCounter((Meter.MeterProvider<Counter>)bytesCounter, TelemetryConstants.Direction.INBOUND, ctx.path()), (Counter)this.closedConnectionCounter.withTag(MetricsBuilderCustomizer.URI_TAG_KEY, ctx.path()));
            }
        });
        builder.pathToServerErrorInterceptor(new Function<String, ErrorInterceptor>(){
            private final Meter.MeterProvider<Counter> serverErrorsCounter;
            {
                this.serverErrorsCounter = Counter.builder((String)"quarkus.websockets.server.endpoint.count.errors").description("Counts all the WebSockets server endpoint errors.").withRegistry(MetricsBuilderCustomizer.this.meterRegistry);
            }

            @Override
            public ErrorInterceptor apply(String path) {
                return new ErrorCountingInterceptor((Counter)this.serverErrorsCounter.withTag(MetricsBuilderCustomizer.URI_TAG_KEY, path));
            }
        });
        builder.pathToServerSendingInterceptor(MetricsBuilderCustomizer.createSendingInterceptor((Meter.MeterProvider<Counter>)bytesCounter, (Meter.MeterProvider<Counter>)messagesCounter));
        builder.pathToServerConnectionInterceptor(new Function<String, ConnectionInterceptor>(){
            private final Meter.MeterProvider<Counter> connectionOpenCounter;
            private final Meter.MeterProvider<Counter> connectionOpeningFailedCounter;
            {
                this.connectionOpenCounter = Counter.builder((String)"quarkus.websockets.server.connections.opened").description("Number of opened server connections.").withRegistry(MetricsBuilderCustomizer.this.meterRegistry);
                this.connectionOpeningFailedCounter = Counter.builder((String)"quarkus.websockets.server.connections.opened.errors").description("Number of failures occurred when opening server connection failed.").withRegistry(MetricsBuilderCustomizer.this.meterRegistry);
            }

            @Override
            public ConnectionInterceptor apply(String path) {
                return new MetricsConnectionInterceptor((Counter)this.connectionOpenCounter.withTag(MetricsBuilderCustomizer.URI_TAG_KEY, path), (Counter)this.connectionOpeningFailedCounter.withTag(MetricsBuilderCustomizer.URI_TAG_KEY, path));
            }
        });
    }

    private void addClientMetricsSupport(WebSocketTelemetryProviderBuilder builder) {
        final Meter.MeterProvider messagesCounter = Counter.builder((String)"quarkus.websockets.client.count").description("Number of messages sent and received by client endpoints.").withRegistry(this.meterRegistry);
        final Meter.MeterProvider bytesCounter = Counter.builder((String)"quarkus.websockets.client.bytes").description("Number of bytes sent and received by client endpoints.").withRegistry(this.meterRegistry);
        builder.clientEndpointDecorator(new Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint>(){
            private final Meter.MeterProvider<Counter> closedConnectionCounter;
            {
                this.closedConnectionCounter = Counter.builder((String)"quarkus.websockets.client.connections.closed").description("Number of closed client WebSocket connections.").withRegistry(MetricsBuilderCustomizer.this.meterRegistry);
            }

            @Override
            public WebSocketEndpoint apply(TelemetryWebSocketEndpointContext ctx) {
                return new MetricsForwardingWebSocketEndpoint(ctx.endpoint(), MetricsBuilderCustomizer.createCounter((Meter.MeterProvider<Counter>)messagesCounter, TelemetryConstants.Direction.INBOUND, ctx.path()), MetricsBuilderCustomizer.createCounter((Meter.MeterProvider<Counter>)bytesCounter, TelemetryConstants.Direction.INBOUND, ctx.path()), (Counter)this.closedConnectionCounter.withTag(MetricsBuilderCustomizer.URI_TAG_KEY, ctx.path()));
            }
        });
        builder.pathToClientErrorInterceptor(new Function<String, ErrorInterceptor>(){
            private final Meter.MeterProvider<Counter> clientErrorsCounter;
            {
                this.clientErrorsCounter = Counter.builder((String)"quarkus.websockets.client.endpoint.count.errors").description("Counts all the WebSockets client endpoint errors.").withRegistry(MetricsBuilderCustomizer.this.meterRegistry);
            }

            @Override
            public ErrorInterceptor apply(String path) {
                return new ErrorCountingInterceptor((Counter)this.clientErrorsCounter.withTag(MetricsBuilderCustomizer.URI_TAG_KEY, path));
            }
        });
        builder.pathToClientSendingInterceptor(MetricsBuilderCustomizer.createSendingInterceptor((Meter.MeterProvider<Counter>)bytesCounter, (Meter.MeterProvider<Counter>)messagesCounter));
        builder.pathToClientConnectionInterceptor(new Function<String, ConnectionInterceptor>(){
            private final Meter.MeterProvider<Counter> connectionOpenCounter;
            private final Meter.MeterProvider<Counter> connectionOpeningFailedCounter;
            {
                this.connectionOpenCounter = Counter.builder((String)"quarkus.websockets.client.connections.opened").description("Number of opened client connections.").withRegistry(MetricsBuilderCustomizer.this.meterRegistry);
                this.connectionOpeningFailedCounter = Counter.builder((String)"quarkus.websockets.client.connections.opened.errors").description("Number of failures occurred when opening client connection failed.").withRegistry(MetricsBuilderCustomizer.this.meterRegistry);
            }

            @Override
            public ConnectionInterceptor apply(String path) {
                return new MetricsConnectionInterceptor((Counter)this.connectionOpenCounter.withTag(MetricsBuilderCustomizer.URI_TAG_KEY, path), (Counter)this.connectionOpeningFailedCounter.withTag(MetricsBuilderCustomizer.URI_TAG_KEY, path));
            }
        });
    }

    private static Function<String, SendingInterceptor> createSendingInterceptor(final Meter.MeterProvider<Counter> bytesCounter, final Meter.MeterProvider<Counter> messagesCounter) {
        return new Function<String, SendingInterceptor>(){

            @Override
            public SendingInterceptor apply(String path) {
                return new MetricsSendingInterceptor(MetricsBuilderCustomizer.createCounter((Meter.MeterProvider<Counter>)messagesCounter, TelemetryConstants.Direction.OUTBOUND, path), MetricsBuilderCustomizer.createCounter((Meter.MeterProvider<Counter>)bytesCounter, TelemetryConstants.Direction.OUTBOUND, path));
            }
        };
    }

    private static Counter createCounter(Meter.MeterProvider<Counter> counter, TelemetryConstants.Direction direction, String path) {
        return (Counter)counter.withTags(new String[]{URI_TAG_KEY, path, "direction", direction.toString()});
    }
}

