/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetrySupport;
import io.quarkus.websockets.next.runtime.telemetry.TelemetryWebSocketEndpointContext;
import java.util.function.Function;

public final class WebSocketTelemetryProvider {
    private final Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> serverEndpointDecorator;
    private final Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> clientEndpointDecorator;
    private final Function<String, ConnectionInterceptor> pathToClientConnectionInterceptor;
    private final Function<String, ConnectionInterceptor> pathToServerConnectionInterceptor;
    private final boolean clientTelemetryEnabled;
    private final boolean serverTelemetryEnabled;

    WebSocketTelemetryProvider(Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> serverEndpointDecorator, Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> clientEndpointDecorator, Function<String, ConnectionInterceptor> pathToClientConnectionInterceptor, Function<String, ConnectionInterceptor> pathToServerConnectionInterceptor) {
        this.serverTelemetryEnabled = serverEndpointDecorator != null || pathToServerConnectionInterceptor != null;
        this.serverEndpointDecorator = serverEndpointDecorator;
        this.pathToServerConnectionInterceptor = pathToServerConnectionInterceptor;
        this.clientTelemetryEnabled = clientEndpointDecorator != null || pathToClientConnectionInterceptor != null;
        this.clientEndpointDecorator = clientEndpointDecorator;
        this.pathToClientConnectionInterceptor = pathToClientConnectionInterceptor;
    }

    public TelemetrySupport createServerTelemetrySupport(final String path) {
        if (this.serverTelemetryEnabled) {
            return new TelemetrySupport(this.getServerConnectionInterceptor(path)){

                @Override
                public WebSocketEndpoint decorate(WebSocketEndpoint endpoint, WebSocketConnectionBase connection) {
                    if (WebSocketTelemetryProvider.this.serverEndpointDecorator == null) {
                        return endpoint;
                    }
                    return WebSocketTelemetryProvider.this.serverEndpointDecorator.apply(new TelemetryWebSocketEndpointContext(endpoint, connection, path, this.getContextData()));
                }
            };
        }
        return null;
    }

    public TelemetrySupport createClientTelemetrySupport(final String path) {
        if (this.clientTelemetryEnabled) {
            return new TelemetrySupport(this.getClientConnectionInterceptor(path)){

                @Override
                public WebSocketEndpoint decorate(WebSocketEndpoint endpoint, WebSocketConnectionBase connection) {
                    if (WebSocketTelemetryProvider.this.clientEndpointDecorator == null) {
                        return endpoint;
                    }
                    return WebSocketTelemetryProvider.this.clientEndpointDecorator.apply(new TelemetryWebSocketEndpointContext(endpoint, connection, path, this.getContextData()));
                }
            };
        }
        return null;
    }

    private ConnectionInterceptor getServerConnectionInterceptor(String path) {
        return this.pathToServerConnectionInterceptor == null ? null : this.pathToServerConnectionInterceptor.apply(path);
    }

    private ConnectionInterceptor getClientConnectionInterceptor(String path) {
        return this.pathToClientConnectionInterceptor == null ? null : this.pathToClientConnectionInterceptor.apply(path);
    }
}

