/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.webjar.locator.deployment.devui;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.webjar.locator.deployment.devui.WebJarAsset;
import io.quarkus.webjar.locator.deployment.devui.WebJarLibrariesBuildItem;
import io.quarkus.webjar.locator.deployment.devui.WebJarLibrary;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class WebJarLocatorDevModeApiProcessor {
    private static final String WEBJARS_PREFIX = "META-INF/resources/webjars";
    private static final Logger log = Logger.getLogger((String)WebJarLocatorDevModeApiProcessor.class.getName());

    @BuildStep(onlyIf={IsDevelopment.class})
    public void findWebjarsAssets(HttpBuildTimeConfig httpConfig, CurateOutcomeBuildItem curateOutcome, BuildProducer<WebJarLibrariesBuildItem> webJarLibrariesProducer) {
        Map webJarKeys;
        ArrayList<WebJarLibrary> webJarLibraries = new ArrayList<WebJarLibrary>();
        List providers = QuarkusClassLoader.getElements((String)WEBJARS_PREFIX, (boolean)false);
        if (!providers.isEmpty() && !(webJarKeys = (Map)providers.stream().filter(provider -> provider.getDependencyKey() != null && provider.isRuntime()).collect(Collectors.toMap(ClassPathElement::getDependencyKey, provider -> provider, (a, b) -> b, () -> new HashMap(providers.size())))).isEmpty()) {
            String rootPath = httpConfig.rootPath;
            String webjarRootPath = rootPath.endsWith("/") ? rootPath + "webjars/" : rootPath + "/webjars/";
            curateOutcome.getApplicationModel().getDependencies().stream().map(dep -> this.createWebJarLibrary((ResolvedDependency)dep, webjarRootPath, webJarKeys)).filter(Objects::nonNull).forEach(webJarLibraries::add);
        }
        webJarLibrariesProducer.produce((BuildItem)new WebJarLibrariesBuildItem(webJarLibraries));
    }

    private WebJarLibrary createWebJarLibrary(ResolvedDependency dep, String webjarRootPath, Map<ArtifactKey, ClassPathElement> webJarKeys) {
        if (!dep.isRuntimeCp()) {
            return null;
        }
        ClassPathElement provider = webJarKeys.get(dep.getKey());
        if (provider == null) {
            return null;
        }
        WebJarLibrary webJarLibrary = new WebJarLibrary(provider.getDependencyKey().getArtifactId());
        provider.apply(tree -> {
            Path nameDir;
            Path webjarsDir = tree.getPath(WEBJARS_PREFIX);
            try (Stream<Path> webjarsDirPaths = Files.list(webjarsDir);){
                nameDir = webjarsDirPaths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new IOException("Could not find name directory for " + dep.getKey().getArtifactId() + " in " + webjarsDir));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Path root = nameDir;
            StringBuilder urlBase = new StringBuilder(webjarRootPath);
            boolean appendRootPart = true;
            try {
                Path versionDir = nameDir.resolve(dep.getVersion());
                root = Files.isDirectory(versionDir, new LinkOption[0]) ? versionDir : nameDir;
                urlBase.append(nameDir.getFileName().toString()).append("/");
                appendRootPart = false;
            }
            catch (InvalidPathException e) {
                log.warn((Object)("Could not find version directory for " + dep.getKey().getArtifactId() + " " + dep.getVersion() + " in " + nameDir + ", falling back to name directory"));
            }
            webJarLibrary.setVersion(dep.getVersion());
            try {
                WebJarAsset asset = this.createAssetForLibrary(root, urlBase.toString(), appendRootPart);
                webJarLibrary.setRootAsset(asset);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return null;
        });
        return webJarLibrary;
    }

    private WebJarAsset createAssetForLibrary(Path rootPath, String urlBase, boolean appendRootPart) throws IOException {
        WebJarAsset root = new WebJarAsset();
        root.setName(rootPath.getFileName().toString());
        root.setChildren(new LinkedList<WebJarAsset>());
        root.setFileAsset(false);
        urlBase = appendRootPart ? urlBase + root.getName() + "/" : urlBase;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(rootPath);){
            for (Path childPath : directoryStream) {
                if (Files.isDirectory(childPath, new LinkOption[0])) {
                    WebJarAsset childDir = this.createAssetForLibrary(childPath, urlBase, true);
                    root.getChildren().add(childDir);
                    continue;
                }
                WebJarAsset childFile = new WebJarAsset();
                childFile.setName(childPath.getFileName().toString());
                childFile.setFileAsset(true);
                childFile.setUrlPart(urlBase + childFile.getName());
                root.getChildren().add(childFile);
            }
        }
        root.getChildren().sort(Comparator.comparing(WebJarAsset::getName));
        return root;
    }
}

