/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.tests;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class DevUIJsonRPCTest {
    protected static final Logger log = Logger.getLogger(DevUIJsonRPCTest.class);
    protected URI uri;
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonFactory factory = this.mapper.getFactory();
    private final Random random = new Random();
    private final String namespace;
    private final String testUrl;
    private static final ConcurrentHashMap<Integer, WebSocketResponse> RESPONSES = new ConcurrentHashMap();

    public DevUIJsonRPCTest(String namespace) {
        this(namespace, (String)ConfigProvider.getConfig().getValue("test.url", String.class));
    }

    public DevUIJsonRPCTest(String namespace, String testUrl) {
        this.namespace = namespace;
        this.testUrl = testUrl;
        Object nonApplicationRoot = ConfigProvider.getConfig().getOptionalValue("quarkus.http.non-application-root-path", String.class).orElse("q");
        if (!((String)nonApplicationRoot).startsWith("/")) {
            nonApplicationRoot = "/" + (String)nonApplicationRoot;
        }
        this.uri = URI.create(testUrl + (String)nonApplicationRoot + "/dev-ui/json-rpc-ws");
    }

    public <T> T executeJsonRPCMethod(TypeReference typeReference, String methodName) throws Exception {
        return this.executeJsonRPCMethod(typeReference, methodName, null);
    }

    public <T> T executeJsonRPCMethod(TypeReference typeReference, String methodName, Map<String, Object> params) throws Exception {
        int id = this.sendRequest(methodName, params);
        T response = this.getJsonRPCResponse(typeReference, id);
        log.debug((Object)("response = " + response));
        return response;
    }

    public JsonNode executeJsonRPCMethod(String methodName) throws Exception {
        return this.executeJsonRPCMethod(methodName, null);
    }

    public JsonNode executeJsonRPCMethod(String methodName, Map<String, Object> params) throws Exception {
        return this.executeJsonRPCMethod(JsonNode.class, methodName, params);
    }

    public <T> T executeJsonRPCMethod(Class<T> classType, String methodName) throws Exception {
        return this.executeJsonRPCMethod(classType, methodName, null);
    }

    public <T> T executeJsonRPCMethod(Class<T> classType, String methodName, Map<String, Object> params) throws Exception {
        int id = this.sendRequest(methodName, params);
        T response = this.getJsonRPCResponse(classType, id);
        log.debug((Object)("response = " + response));
        return response;
    }

    protected JsonNode toJsonNode(String json) {
        try {
            JsonParser parser = this.factory.createParser(json);
            return (JsonNode)this.mapper.readTree(parser);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> T getJsonRPCResponse(TypeReference typeReference, int id) throws InterruptedException, IOException {
        return this.getJsonRPCResponse(typeReference, id, 0);
    }

    private <T> T getJsonRPCResponse(TypeReference typeReference, int id, int loopCount) throws InterruptedException, IOException {
        JsonNode object = this.objectResultFromJsonRPC(id);
        if (object != null) {
            JavaType jt = this.mapper.getTypeFactory().constructType(typeReference);
            return (T)this.mapper.treeToValue((TreeNode)object, jt);
        }
        if (loopCount > 10) {
            throw new RuntimeException("Too many recursions, message not returned for id [" + id + "]");
        }
        return this.getJsonRPCResponse(typeReference, id, loopCount + 1);
    }

    private <T> T getJsonRPCResponse(Class<T> classType, int id) throws InterruptedException, IOException {
        return this.getJsonRPCResponse(classType, id, 0);
    }

    private <T> T getJsonRPCResponse(Class<T> classType, int id, int loopCount) throws InterruptedException, IOException {
        JsonNode object = this.objectResultFromJsonRPC(id);
        if (object != null) {
            if (classType == null || classType.equals(JsonNode.class)) {
                return (T)object;
            }
            if (classType.equals(String.class)) {
                return (T)object.asText();
            }
            if (classType.equals(Boolean.class)) {
                return (T)Boolean.valueOf(object.asBoolean());
            }
            if (classType.equals(Double.class)) {
                return (T)Double.valueOf(object.asDouble());
            }
            if (classType.equals(Integer.class)) {
                return (T)Integer.valueOf(object.asInt());
            }
            if (classType.equals(Long.class)) {
                return (T)Long.valueOf(object.asLong());
            }
            return (T)this.mapper.treeToValue((TreeNode)object, classType);
        }
        if (loopCount > 10) {
            throw new RuntimeException("Too many recursions, message not returned for id [" + id + "]");
        }
        return this.getJsonRPCResponse(classType, id, loopCount + 1);
    }

    private JsonNode objectResultFromJsonRPC(int id) throws InterruptedException, JsonProcessingException {
        return this.objectResultFromJsonRPC(id, 0);
    }

    private JsonNode objectResultFromJsonRPC(int id, int loopCount) throws InterruptedException, JsonProcessingException {
        if (RESPONSES.containsKey(id)) {
            ObjectNode json;
            JsonNode result;
            WebSocketResponse response = RESPONSES.remove(id);
            if (response != null && (result = (json = (ObjectNode)new ObjectMapper().readTree(response.message())).get("result")) != null) {
                return result.get("object");
            }
            return null;
        }
        if (loopCount > 10) {
            throw new RuntimeException("Too many recursions, message not returned for id [" + id + "]");
        }
        TimeUnit.SECONDS.sleep(3L);
        return this.objectResultFromJsonRPC(id, loopCount + 1);
    }

    private String createJsonRPCRequest(int id, String methodName, Map<String, Object> params) throws IOException {
        ObjectNode request = this.mapper.createObjectNode();
        request.put("jsonrpc", "2.0");
        request.put("id", id);
        request.put("method", this.namespace + "." + methodName);
        ObjectNode jsonParams = this.mapper.createObjectNode();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> p : params.entrySet()) {
                JsonNode convertValue = (JsonNode)this.mapper.convertValue(p.getValue(), JsonNode.class);
                jsonParams.putIfAbsent(p.getKey(), convertValue);
            }
        }
        request.set("params", (JsonNode)jsonParams);
        return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)request);
    }

    private int sendRequest(String methodName, Map<String, Object> params) throws IOException {
        int id = this.random.nextInt(Integer.MAX_VALUE);
        String request = this.createJsonRPCRequest(id, methodName, params);
        log.debug((Object)("request = " + request));
        Vertx vertx = Vertx.vertx();
        HttpClientOptions options = new HttpClientOptions().setDefaultHost(this.uri.getHost()).setDefaultPort(this.uri.getPort());
        HttpClient client = vertx.createHttpClient(options);
        WebSocketConnectOptions socketOptions = new WebSocketConnectOptions().setHost(this.uri.getHost()).setPort(Integer.valueOf(this.uri.getPort())).setURI(this.uri.getPath());
        client.webSocket(socketOptions, ar -> {
            if (ar.succeeded()) {
                WebSocket socket = (WebSocket)ar.result();
                Buffer accumulatedBuffer = Buffer.buffer();
                socket.frameHandler(e -> {
                    Buffer b = accumulatedBuffer.appendBuffer(e.binaryData());
                    if (e.isFinal()) {
                        RESPONSES.put(id, new WebSocketResponse(b.toString()));
                    }
                });
                socket.writeTextMessage(request);
                socket.exceptionHandler(e -> {
                    RESPONSES.put(id, new WebSocketResponse((Throwable)e));
                    vertx.close();
                });
                socket.closeHandler(v -> vertx.close());
            } else {
                RESPONSES.put(id, new WebSocketResponse(ar.cause()));
                vertx.close();
            }
        });
        return id;
    }

    private static class WebSocketResponse {
        private final String message;
        private final Throwable throwable;

        public WebSocketResponse(String message) {
            this.message = message;
            this.throwable = null;
        }

        public WebSocketResponse(Throwable throwable) {
            this.message = null;
            this.throwable = throwable;
        }

        String message() {
            if (this.throwable != null) {
                throw new IllegalStateException("Request failed: " + this.throwable.getMessage(), this.throwable);
            }
            return this.message;
        }
    }
}

