/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.core.quarkus37;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class AddMavenCompilerAnnotationProcessor
extends Recipe {
    private static final XPathMatcher BUILD_MATCHER = new XPathMatcher("/project/build");
    private static final String MAVEN_COMPILER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final String MAVEN_COMPILER_PLUGIN_ARTIFACT_ID = "maven-compiler-plugin";
    @Option(displayName="Annotation processor groupId", description="The groupId of the annotation processor.", example="org.hibernate.orm", required=true)
    private final String groupId;
    @Option(displayName="Annotation processor artifactId", description="The artifactId of the annotation processor.", example="hibernate-jpamodelgen", required=true)
    private final String artifactId;
    @Option(displayName="Enforce managed version", description="If the new annotation processor has a managed version, this flag can be used to explicitly set the version on the annotation processor with the version of the managed dependency. The default for this flag is `false`.", required=false)
    @Nullable
    private final Boolean enforceManagedVersion;
    @Option(displayName="Annotation processor artifactId", description="The version of the Maven Compiler plugin to use if not present.", example="hibernate-jpamodelgen", required=false)
    @Nullable
    private final String mavenCompilerPluginVersion;

    public String getDisplayName() {
        return "Add an annotation processor to the Maven Compiler plugin configuration";
    }

    public String getDescription() {
        return "Add an annotation processor to the Maven Compiler plugin configuration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AddMavenCompilerPluginAnnotationProcessorVisitor();
    }

    @ConstructorProperties(value={"groupId", "artifactId", "enforceManagedVersion", "mavenCompilerPluginVersion"})
    @Generated
    public AddMavenCompilerAnnotationProcessor(String groupId, String artifactId, @Nullable Boolean enforceManagedVersion, @Nullable String mavenCompilerPluginVersion) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.enforceManagedVersion = enforceManagedVersion;
        this.mavenCompilerPluginVersion = mavenCompilerPluginVersion;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    @Generated
    public Boolean getEnforceManagedVersion() {
        return this.enforceManagedVersion;
    }

    @Nullable
    @Generated
    public String getMavenCompilerPluginVersion() {
        return this.mavenCompilerPluginVersion;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddMavenCompilerAnnotationProcessor(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", enforceManagedVersion=" + this.getEnforceManagedVersion() + ", mavenCompilerPluginVersion=" + this.getMavenCompilerPluginVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddMavenCompilerAnnotationProcessor)) {
            return false;
        }
        AddMavenCompilerAnnotationProcessor other = (AddMavenCompilerAnnotationProcessor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$enforceManagedVersion = this.getEnforceManagedVersion();
        Boolean other$enforceManagedVersion = other.getEnforceManagedVersion();
        if (this$enforceManagedVersion == null ? other$enforceManagedVersion != null : !((Object)this$enforceManagedVersion).equals(other$enforceManagedVersion)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$mavenCompilerPluginVersion = this.getMavenCompilerPluginVersion();
        String other$mavenCompilerPluginVersion = other.getMavenCompilerPluginVersion();
        return !(this$mavenCompilerPluginVersion == null ? other$mavenCompilerPluginVersion != null : !this$mavenCompilerPluginVersion.equals(other$mavenCompilerPluginVersion));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddMavenCompilerAnnotationProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $enforceManagedVersion = this.getEnforceManagedVersion();
        result = result * 59 + ($enforceManagedVersion == null ? 43 : ((Object)$enforceManagedVersion).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $mavenCompilerPluginVersion = this.getMavenCompilerPluginVersion();
        result = result * 59 + ($mavenCompilerPluginVersion == null ? 43 : $mavenCompilerPluginVersion.hashCode());
        return result;
    }

    private class AddMavenCompilerPluginAnnotationProcessorVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private AddMavenCompilerPluginAnnotationProcessorVisitor() {
        }

        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            Xml.Tag root = document.getRoot();
            if (!root.getChild("build").isPresent()) {
                document = (Xml.Document)new AddToTagVisitor(root, Xml.Tag.build((String)"<build/>")).visitNonNull((Tree)document, (Object)ctx, this.getCursor().getParentOrThrow());
            }
            return super.visitDocument(document, (Object)ctx);
        }

        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag buildTag = super.visitTag(tag, (Object)ctx);
            if (BUILD_MATCHER.matches(this.getCursor())) {
                String managedVersion;
                Xml.Tag pluginsTag;
                Optional maybePluginsTag = buildTag.getChild("plugins");
                if (maybePluginsTag.isPresent()) {
                    pluginsTag = (Xml.Tag)maybePluginsTag.get();
                } else {
                    buildTag = (Xml.Tag)new AddToTagVisitor(buildTag, Xml.Tag.build((String)"<plugins/>")).visitNonNull((Tree)buildTag, (Object)ctx, this.getCursor().getParentOrThrow());
                    pluginsTag = (Xml.Tag)buildTag.getChild("plugins").get();
                }
                Optional<Xml.Tag> maybeMavenCompilerPluginTag = pluginsTag.getChildren().stream().filter(plugin -> "plugin".equals(plugin.getName()) && AddMavenCompilerAnnotationProcessor.MAVEN_COMPILER_PLUGIN_GROUP_ID.equals(plugin.getChildValue("groupId").orElse(AddMavenCompilerAnnotationProcessor.MAVEN_COMPILER_PLUGIN_GROUP_ID)) && AddMavenCompilerAnnotationProcessor.MAVEN_COMPILER_PLUGIN_ARTIFACT_ID.equals(plugin.getChildValue("artifactId").orElse(null))).findAny();
                String annotationProcessorPath = "<groupId>" + AddMavenCompilerAnnotationProcessor.this.groupId + "</groupId>\n<artifactId>" + AddMavenCompilerAnnotationProcessor.this.artifactId + "</artifactId>";
                if (Boolean.TRUE.equals(AddMavenCompilerAnnotationProcessor.this.enforceManagedVersion) && (managedVersion = this.getManagedVersion(AddMavenCompilerAnnotationProcessor.this.groupId, AddMavenCompilerAnnotationProcessor.this.artifactId)) != null) {
                    annotationProcessorPath = annotationProcessorPath + "<version>" + managedVersion + "</version>";
                }
                if (maybeMavenCompilerPluginTag.isPresent()) {
                    Xml.Tag mavenCompilerPluginTag = maybeMavenCompilerPluginTag.get();
                    Optional configuration = mavenCompilerPluginTag.getChild("configuration");
                    if (configuration.isPresent()) {
                        Optional annotationProcessorPathsWrapper = ((Xml.Tag)configuration.get()).getChild("annotationProcessorPaths");
                        if (annotationProcessorPathsWrapper.isPresent()) {
                            String childName;
                            List annotationProcessorPaths = ((Xml.Tag)annotationProcessorPathsWrapper.get()).getChildren();
                            String string = childName = annotationProcessorPaths.size() > 0 ? ((Xml.Tag)annotationProcessorPaths.get(0)).getName() : "path";
                            if (!annotationProcessorPaths.stream().anyMatch(t -> AddMavenCompilerAnnotationProcessor.this.groupId.equals(t.getChildValue("groupId").orElse(null)) && AddMavenCompilerAnnotationProcessor.this.artifactId.equals(t.getChildValue("artifactId").orElse(null)))) {
                                buildTag = AddToTagVisitor.addToTag((Xml.Tag)buildTag, (Xml.Tag)((Xml.Tag)annotationProcessorPathsWrapper.get()), (Xml.Tag)Xml.Tag.build((String)("<" + childName + ">\n" + annotationProcessorPath + "\n</" + childName + ">")), (Cursor)this.getCursor().getParentOrThrow());
                            }
                        } else {
                            buildTag = AddToTagVisitor.addToTag((Xml.Tag)buildTag, (Xml.Tag)((Xml.Tag)configuration.get()), (Xml.Tag)Xml.Tag.build((String)("<annotationProcessorPaths>\n<path>\n" + annotationProcessorPath + "\n</path>\n</annotationProcessorPaths>")), (Cursor)this.getCursor().getParentOrThrow());
                        }
                    } else {
                        buildTag = AddToTagVisitor.addToTag((Xml.Tag)buildTag, (Xml.Tag)mavenCompilerPluginTag, (Xml.Tag)Xml.Tag.build((String)("<configuration>\n<annotationProcessorPaths>\n<path>\n" + annotationProcessorPath + "\n</path>\n</annotationProcessorPaths>\n</configuration>")), (Cursor)this.getCursor().getParentOrThrow());
                    }
                } else {
                    boolean mavenCompilerPluginVersionDefined = false;
                    for (MavenResolutionResult currentResolutionResult = this.getResolutionResult(); currentResolutionResult != null; currentResolutionResult = currentResolutionResult.getParent()) {
                        if (!currentResolutionResult.getPom().getPluginManagement().stream().anyMatch(p -> (AddMavenCompilerAnnotationProcessor.MAVEN_COMPILER_PLUGIN_GROUP_ID.equals(p.getGroupId()) || p.getGroupId() == null) && AddMavenCompilerAnnotationProcessor.MAVEN_COMPILER_PLUGIN_ARTIFACT_ID.equals(p.getArtifactId()) && p.getVersion() != null) && !currentResolutionResult.getPom().getPlugins().stream().anyMatch(p -> (AddMavenCompilerAnnotationProcessor.MAVEN_COMPILER_PLUGIN_GROUP_ID.equals(p.getGroupId()) || p.getGroupId() == null) && AddMavenCompilerAnnotationProcessor.MAVEN_COMPILER_PLUGIN_ARTIFACT_ID.equals(p.getArtifactId()) && p.getVersion() != null)) continue;
                        mavenCompilerPluginVersionDefined = true;
                        break;
                    }
                    buildTag = AddToTagVisitor.addToTag((Xml.Tag)buildTag, (Xml.Tag)pluginsTag, (Xml.Tag)Xml.Tag.build((String)("<plugin>\n<artifactId>maven-compiler-plugin</artifactId>\n" + (String)(AddMavenCompilerAnnotationProcessor.this.mavenCompilerPluginVersion != null && !mavenCompilerPluginVersionDefined ? "<version>" + AddMavenCompilerAnnotationProcessor.this.mavenCompilerPluginVersion + "</version>\n" : "") + "<configuration>\n<annotationProcessorPaths>\n<path>\n" + annotationProcessorPath + "\n</path>\n</annotationProcessorPaths>\n</configuration>\n</plugin>")), (Cursor)this.getCursor().getParentOrThrow());
                }
            }
            return buildTag;
        }

        private String getManagedVersion(String groupId, String artifactId) {
            MavenResolutionResult result = this.getResolutionResult();
            for (ResolvedManagedDependency managedDependency : result.getPom().getDependencyManagement()) {
                if (!groupId.equals(managedDependency.getGroupId()) || !artifactId.equals(managedDependency.getArtifactId())) continue;
                return managedDependency.getVersion();
            }
            return null;
        }
    }
}

