/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime.keystores;

import io.quarkus.tls.runtime.config.TrustStoreConfig;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.smallrye.mutiny.unchecked.UncheckedFunction;
import io.vertx.core.Vertx;
import io.vertx.core.net.TrustOptions;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import org.jboss.logging.Logger;

public class ExpiryTrustOptions
implements TrustOptions {
    private final TrustOptions delegate;
    private final TrustStoreConfig.CertificateExpiryPolicy policy;
    private static final Logger LOGGER = Logger.getLogger(ExpiryTrustOptions.class);

    public ExpiryTrustOptions(TrustOptions delegate, TrustStoreConfig.CertificateExpiryPolicy certificateExpiryPolicy) {
        this.delegate = delegate;
        this.policy = certificateExpiryPolicy;
    }

    public TrustOptions unwrap() {
        return this.delegate;
    }

    public TrustOptions copy() {
        return this;
    }

    public TrustManagerFactory getTrustManagerFactory(Vertx vertx) throws Exception {
        final TrustManagerFactory tmf = this.delegate.getTrustManagerFactory(vertx);
        return new TrustManagerFactory(new TrustManagerFactorySpi(){

            @Override
            protected void engineInit(KeyStore ks) throws KeyStoreException {
                tmf.init(ks);
            }

            @Override
            protected void engineInit(ManagerFactoryParameters spec) throws InvalidAlgorithmParameterException {
                tmf.init(spec);
            }

            @Override
            protected TrustManager[] engineGetTrustManagers() {
                TrustManager[] managers = tmf.getTrustManagers();
                return ExpiryTrustOptions.this.getWrappedTrustManagers(managers);
            }
        }, tmf.getProvider(), tmf.getAlgorithm()){};
    }

    public Function<String, TrustManager[]> trustManagerMapper(final Vertx vertx) {
        return Unchecked.function((UncheckedFunction)new UncheckedFunction<String, TrustManager[]>(){

            public TrustManager[] apply(String s) throws Exception {
                TrustManager[] tms = (TrustManager[])ExpiryTrustOptions.this.delegate.trustManagerMapper(vertx).apply(s);
                return ExpiryTrustOptions.this.getWrappedTrustManagers(tms);
            }
        });
    }

    private TrustManager[] getWrappedTrustManagers(TrustManager[] tms) {
        TrustManager[] wrapped = new TrustManager[tms.length];
        for (int i = 0; i < tms.length; ++i) {
            TrustManager manager = tms[i];
            wrapped[i] = !(manager instanceof X509TrustManager) ? manager : new ExpiryAwareX509TrustManager((X509TrustManager)manager);
        }
        return wrapped;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ExpiryTrustOptions that = (ExpiryTrustOptions)obj;
            return Objects.equals(this.delegate, that.delegate) && Objects.equals((Object)this.policy, (Object)that.policy);
        }
        return false;
    }

    private class ExpiryAwareX509TrustManager
    implements X509TrustManager {
        final X509TrustManager tm;

        private ExpiryAwareX509TrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyExpiration(chain);
            this.tm.checkClientTrusted(chain, authType);
        }

        private void verifyExpiration(X509Certificate[] chain) throws CertificateExpiredException, CertificateNotYetValidException {
            for (X509Certificate cert : chain) {
                try {
                    cert.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    if (ExpiryTrustOptions.this.policy == TrustStoreConfig.CertificateExpiryPolicy.REJECT) {
                        LOGGER.error((Object)"A certificate has expired - rejecting", (Throwable)e);
                        throw e;
                    }
                    LOGGER.warn((Object)"A certificate has expired", (Throwable)e);
                }
                catch (CertificateNotYetValidException e) {
                    if (ExpiryTrustOptions.this.policy == TrustStoreConfig.CertificateExpiryPolicy.REJECT) {
                        LOGGER.error((Object)"A certificate is not yet valid - rejecting", (Throwable)e);
                        throw e;
                    }
                    LOGGER.warn((Object)"A certificate is not yet valid", (Throwable)e);
                }
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyExpiration(chain);
            this.tm.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }
    }
}

