/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cloud.config.client.runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.runtime.ResettableSystemProperties;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.spring.cloud.config.client.runtime.Response;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientConfig;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientGateway;
import io.smallrye.mutiny.Uni;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyStoreOptionsBase;
import io.vertx.core.net.PfxOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public class VertxSpringCloudConfigGateway
implements SpringCloudConfigClientGateway {
    private static final Logger log = Logger.getLogger(VertxSpringCloudConfigGateway.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String PKS_12 = "PKS12";
    private static final String JKS = "JKS";
    private final SpringCloudConfigClientConfig config;
    private final Vertx vertx;
    private final WebClient webClient;
    private final URI baseURI;

    public VertxSpringCloudConfigGateway(SpringCloudConfigClientConfig config) {
        this.config = config;
        try {
            this.baseURI = this.determineBaseUri(config);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Value: '" + config.url() + "' of property 'quarkus.spring-cloud-config.url' is invalid", e);
        }
        this.vertx = this.createVertxInstance();
        this.webClient = VertxSpringCloudConfigGateway.createHttpClient(this.vertx, config);
    }

    private Vertx createVertxInstance() {
        try (ResettableSystemProperties resettableSystemProperties = ResettableSystemProperties.of((String)"vertx.disableDnsResolver", (String)"true");){
            Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions());
            return vertx;
        }
    }

    public static WebClient createHttpClient(Vertx vertx, SpringCloudConfigClientConfig config) {
        WebClientOptions webClientOptions = new WebClientOptions().setConnectTimeout((int)config.connectionTimeout().toMillis()).setIdleTimeout((int)config.readTimeout().getSeconds());
        try {
            KeyStoreOptionsBase storeOptions;
            String type;
            if (config.trustStore().isPresent()) {
                Path trustStorePath = config.trustStore().get();
                type = VertxSpringCloudConfigGateway.determineStoreType(trustStorePath);
                storeOptions = VertxSpringCloudConfigGateway.storeOptions(trustStorePath, config.trustStorePassword(), VertxSpringCloudConfigGateway.createStoreOptions(type));
                if (VertxSpringCloudConfigGateway.isPfx(type)) {
                    webClientOptions.setPfxTrustOptions((PfxOptions)storeOptions);
                } else {
                    webClientOptions.setTrustStoreOptions((JksOptions)storeOptions);
                }
            } else if (config.trustCerts()) {
                VertxSpringCloudConfigGateway.skipVerify(webClientOptions);
            }
            if (config.keyStore().isPresent()) {
                Path keyStorePath = config.keyStore().get();
                type = VertxSpringCloudConfigGateway.determineStoreType(keyStorePath);
                storeOptions = VertxSpringCloudConfigGateway.storeOptions(keyStorePath, config.keyStorePassword(), VertxSpringCloudConfigGateway.createStoreOptions(type));
                if (VertxSpringCloudConfigGateway.isPfx(type)) {
                    webClientOptions.setPfxKeyCertOptions((PfxOptions)storeOptions);
                } else {
                    webClientOptions.setKeyStoreOptions((JksOptions)storeOptions);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return WebClient.create((Vertx)vertx, (WebClientOptions)webClientOptions);
    }

    private static void skipVerify(WebClientOptions options) {
        options.setTrustAll(true);
        options.setVerifyHost(false);
    }

    private static KeyStoreOptionsBase createStoreOptions(String type) {
        if (VertxSpringCloudConfigGateway.isPfx(type)) {
            return new PfxOptions();
        }
        return new JksOptions();
    }

    private static boolean isPfx(String type) {
        return PKS_12.equals(type);
    }

    private static <T extends KeyStoreOptionsBase> KeyStoreOptionsBase storeOptions(Path storePath, Optional<String> storePassword, T store) throws Exception {
        return store.setPassword(storePassword.orElse("")).setValue(Buffer.buffer((byte[])VertxSpringCloudConfigGateway.storeBytes(storePath)));
    }

    private static String determineStoreType(Path keyStorePath) {
        String pathName = keyStorePath.toString().toLowerCase();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return PKS_12;
        }
        return JKS;
    }

    private static byte[] storeBytes(Path keyStorePath) throws Exception {
        InputStream classPathResource = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassPathUtils.toResourceName((Path)keyStorePath));
        if (classPathResource != null) {
            try (InputStream is = classPathResource;){
                byte[] byArray = VertxSpringCloudConfigGateway.allBytes(is);
                return byArray;
            }
        }
        try (InputStream is = Files.newInputStream(keyStorePath, new OpenOption[0]);){
            byte[] byArray = VertxSpringCloudConfigGateway.allBytes(is);
            return byArray;
        }
    }

    private static byte[] allBytes(InputStream inputStream) throws Exception {
        return inputStream.readAllBytes();
    }

    private URI determineBaseUri(SpringCloudConfigClientConfig springCloudConfigClientConfig) throws URISyntaxException {
        String url = springCloudConfigClientConfig.url();
        if (null == url || url.isEmpty()) {
            throw new IllegalArgumentException("The 'quarkus.spring-cloud-config.url' property cannot be empty");
        }
        if (url.endsWith("/")) {
            return new URI(url.substring(0, url.length() - 1));
        }
        return new URI(url);
    }

    private String finalURI(String applicationName, String profile) {
        String path = this.baseURI.getPath();
        ArrayList<String> finalPathSegments = new ArrayList<String>();
        finalPathSegments.add(path);
        finalPathSegments.add(applicationName);
        finalPathSegments.add(profile);
        if (this.config.label().isPresent()) {
            finalPathSegments.add(this.config.label().get());
        }
        return String.join((CharSequence)"/", finalPathSegments);
    }

    @Override
    public Uni<Response> exchange(String applicationName, String profile) {
        String requestURI = this.finalURI(applicationName, profile);
        String finalURI = this.getFinalURI(applicationName, profile);
        HttpRequest request = this.webClient.get(this.getPort(this.baseURI), this.baseURI.getHost(), requestURI).ssl(Boolean.valueOf(this.isHttps(this.baseURI))).putHeader("Accept", "application/json");
        if (this.config.usernameAndPasswordSet()) {
            request.basicAuthentication(this.config.username().get(), this.config.password().get());
        }
        for (Map.Entry<String, String> entry : this.config.headers().entrySet()) {
            request.putHeader(entry.getKey(), entry.getValue());
        }
        log.debug((Object)("Attempting to read configuration from '" + finalURI + "'."));
        return request.send().map(r -> {
            log.debug((Object)("Received HTTP response code '" + r.statusCode() + "'"));
            if (r.statusCode() != 200) {
                throw new RuntimeException("Got unexpected HTTP response code " + r.statusCode() + " from " + finalURI);
            }
            String bodyAsString = r.bodyAsString();
            if (bodyAsString.isEmpty()) {
                throw new RuntimeException("Got empty HTTP response body " + finalURI);
            }
            try {
                log.debug((Object)"Attempting to deserialize response");
                return (Response)OBJECT_MAPPER.readValue(bodyAsString, Response.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Got unexpected error " + e.getOriginalMessage());
            }
        });
    }

    private boolean isHttps(URI uri) {
        return uri.getScheme().contains("https");
    }

    private int getPort(URI uri) {
        return uri.getPort() != -1 ? uri.getPort() : (this.isHttps(uri) ? 443 : 80);
    }

    private String getFinalURI(String applicationName, String profile) {
        String finalURI = this.baseURI.toString() + "/" + applicationName + "/" + profile;
        if (this.config.label().isPresent()) {
            finalURI = finalURI + "/" + this.config.label().get();
        }
        return finalURI;
    }

    @Override
    public void close() {
        this.webClient.close();
        this.vertx.closeAndAwait();
    }
}

