/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime.filter;

import io.quarkus.runtime.rest.DisabledRestEndpoints;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;

public class DisabledRestEndpointsFilter
implements OASFilter {
    public void filterOpenAPI(OpenAPI openAPI) {
        Map disabledEndpointsMap = DisabledRestEndpoints.get();
        if (disabledEndpointsMap != null) {
            Map pathItems = openAPI.getPaths().getPathItems();
            ArrayList<String> emptyPathItems = new ArrayList<String>();
            if (pathItems != null) {
                for (Map.Entry entry : pathItems.entrySet()) {
                    String path = (String)entry.getKey();
                    PathItem pathItem = (PathItem)entry.getValue();
                    List disabledMethodsForThisPath = (List)disabledEndpointsMap.get(path);
                    if (disabledMethodsForThisPath == null) continue;
                    disabledMethodsForThisPath.forEach(method -> pathItem.setOperation(PathItem.HttpMethod.valueOf((String)method), null));
                    if (!pathItem.getOperations().isEmpty()) continue;
                    emptyPathItems.add(path);
                }
                emptyPathItems.forEach(arg_0 -> ((Paths)openAPI.getPaths()).removePathItem(arg_0));
            }
        }
    }
}

