/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime.filter;

import io.quarkus.runtime.rest.DisabledRestEndpoints;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;

public class DisabledRestEndpointsFilter
implements OASFilter {
    public void filterOpenAPI(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        DisabledRestEndpointsFilter.disabledRestEndpoints().filter(pathMethods -> paths.hasPathItem((String)pathMethods.getKey())).forEach(pathMethods -> {
            String path = (String)pathMethods.getKey();
            PathItem pathItem = paths.getPathItem(path);
            Optional.ofNullable((List)pathMethods.getValue()).orElseGet(Collections::emptyList).stream().map(PathItem.HttpMethod::valueOf).forEach(method -> pathItem.setOperation(method, null));
            if (pathItem.getOperations().isEmpty()) {
                paths.removePathItem(path);
            }
        });
    }

    static Stream<Map.Entry<String, List<String>>> disabledRestEndpoints() {
        return Optional.ofNullable(DisabledRestEndpoints.get()).orElseGet(Collections::emptyMap).entrySet().stream().map(pathMethods -> Map.entry(DisabledRestEndpointsFilter.stripSlash((String)pathMethods.getKey()), (List)pathMethods.getValue()));
    }

    static String stripSlash(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }
}

