/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime.spi.datafetcher;

import io.smallrye.graphql.schema.model.Execute;
import io.smallrye.graphql.schema.model.Operation;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.util.concurrent.Callable;

public final class BlockingHelper {
    private BlockingHelper() {
    }

    public static boolean blockingShouldExecuteNonBlocking(Operation operation, Context vc) {
        return operation.getExecute().equals((Object)Execute.NON_BLOCKING);
    }

    public static boolean nonBlockingShouldExecuteBlocking(Operation operation, Context vc) {
        return operation.getExecute().equals((Object)Execute.BLOCKING) && vc.isEventLoopContext();
    }

    public static void runBlocking(Context vc, Callable<Object> contextualCallable, Promise result) {
        vc.executeBlocking(contextualCallable).onComplete((Handler)result);
    }
}

