/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.security.deployment.SecurityAnnotationsRegistrar;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.RolesAllowed;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class SecurityTransformerUtils {
    public static final DotName DENY_ALL = DotName.createSimple((String)DenyAll.class.getName());
    public static final DotName ROLES_ALLOWED = DotName.createSimple((String)RolesAllowed.class.getName());
    private static final Set<DotName> SECURITY_ANNOTATIONS = SecurityAnnotationsRegistrar.SECURITY_BINDINGS.stream().map(InterceptorBindingRegistrar.InterceptorBinding::getName).collect(Collectors.toSet());

    public static boolean hasStandardSecurityAnnotation(MethodInfo methodInfo) {
        return SecurityTransformerUtils.hasStandardSecurityAnnotation(methodInfo.annotations());
    }

    public static boolean hasStandardSecurityAnnotation(ClassInfo classInfo) {
        return SecurityTransformerUtils.hasStandardSecurityAnnotation(classInfo.declaredAnnotations());
    }

    private static boolean hasStandardSecurityAnnotation(Collection<AnnotationInstance> instances) {
        for (AnnotationInstance instance : instances) {
            if (!SECURITY_ANNOTATIONS.contains(instance.name())) continue;
            return true;
        }
        return false;
    }

    public static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(MethodInfo methodInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(methodInfo.annotations());
    }

    public static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(ClassInfo classInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(classInfo.declaredAnnotations());
    }

    private static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(Collection<AnnotationInstance> instances) {
        for (AnnotationInstance instance : instances) {
            if (!SECURITY_ANNOTATIONS.contains(instance.name())) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }
}

