/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public abstract class DefaultInvoker
implements ScheduledInvoker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> invoke(ScheduledExecution execution) throws Exception {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            return this.invokeBean(execution);
        }
        requestContext.activate();
        InjectableContext.ContextState state = requestContext.getState();
        try {
            CompletionStage<Void> completionStage = this.invokeBean(execution).whenComplete((v, t) -> requestContext.destroy(state));
            return completionStage;
        }
        catch (Throwable e) {
            requestContext.terminate();
            CompletionStage<Void> completionStage = CompletableFuture.failedStage(e);
            return completionStage;
        }
        finally {
            requestContext.deactivate();
        }
    }

    protected abstract CompletionStage<Void> invokeBean(ScheduledExecution var1);
}

