/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.rest.client.reactive.runtime.AnnotationRegisteredProviders;
import io.quarkus.rest.client.reactive.runtime.BeanGrabber;
import io.quarkus.rest.client.reactive.runtime.DefaultMicroprofileRestClientExceptionMapper;
import io.quarkus.rest.client.reactive.runtime.MicroProfileRestClientResponseFilter;
import io.quarkus.rest.client.reactive.runtime.ProxyAddressUtil;
import io.quarkus.rest.client.reactive.runtime.RestClientListeners;
import io.quarkus.restclient.config.RestClientLoggingConfig;
import io.quarkus.restclient.config.RestClientsConfig;
import io.quarkus.runtime.configuration.MemorySize;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.ext.QueryParamStyle;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.InvalidRestClientDefinitionException;
import org.jboss.resteasy.reactive.client.api.LoggingScope;
import org.jboss.resteasy.reactive.client.handlers.RedirectHandler;
import org.jboss.resteasy.reactive.client.impl.ClientBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.client.impl.multipart.PausableHttpPostRequestEncoder;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.jaxrs.MultiQueryParamMode;

public class RestClientBuilderImpl
implements RestClientBuilder {
    private static final String DEFAULT_MAPPER_DISABLED = "microprofile.rest.client.disable.default.mapper";
    private static final String TLS_TRUST_ALL = "quarkus.tls.trust-all";
    private static final String ENABLE_COMPRESSION = "quarkus.http.enable-compression";
    private final ClientBuilderImpl clientBuilder = (ClientBuilderImpl)new ClientBuilderImpl().withConfig((Configuration)new ConfigurationImpl(RuntimeType.CLIENT));
    private final List<ResponseExceptionMapper<?>> exceptionMappers = new ArrayList();
    private final List<RedirectHandler> redirectHandlers = new ArrayList<RedirectHandler>();
    private final List<ParamConverterProvider> paramConverterProviders = new ArrayList<ParamConverterProvider>();
    private URI uri;
    private boolean followRedirects;
    private QueryParamStyle queryParamStyle;
    private String multipartPostEncoderMode;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String nonProxyHosts;
    private ClientLogger clientLogger;
    private LoggingScope loggingScope;
    private Integer loggingBodyLimit;
    private Boolean trustAll;

    public RestClientBuilderImpl baseUrl(URL url) {
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to convert REST client URL to URI", e);
        }
        return this;
    }

    public RestClientBuilderImpl connectTimeout(long timeout, TimeUnit timeUnit) {
        this.clientBuilder.connectTimeout(timeout, timeUnit);
        return this;
    }

    public RestClientBuilderImpl readTimeout(long timeout, TimeUnit timeUnit) {
        this.clientBuilder.readTimeout(timeout, timeUnit);
        return this;
    }

    public RestClientBuilderImpl sslContext(SSLContext sslContext) {
        this.clientBuilder.sslContext(sslContext);
        return this;
    }

    public RestClientBuilderImpl verifyHost(boolean verifyHost) {
        this.clientBuilder.verifyHost(verifyHost);
        return this;
    }

    public RestClientBuilderImpl trustStore(KeyStore trustStore) {
        this.clientBuilder.trustStore(trustStore);
        return this;
    }

    public RestClientBuilderImpl trustStore(KeyStore trustStore, String trustStorePassword) {
        this.clientBuilder.trustStore(trustStore, trustStorePassword.toCharArray());
        return this;
    }

    public RestClientBuilderImpl keyStore(KeyStore keyStore, String keystorePassword) {
        this.clientBuilder.keyStore(keyStore, keystorePassword);
        return this;
    }

    public RestClientBuilderImpl hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.clientBuilder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    public RestClientBuilderImpl followRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    public RestClientBuilderImpl proxyAddress(String proxyHost, int proxyPort) {
        if (proxyHost == null) {
            throw new IllegalArgumentException("proxyHost must not be null");
        }
        if (!(proxyPort > 0 && proxyPort <= 65535 || proxyHost.equals("none"))) {
            throw new IllegalArgumentException("Invalid port number");
        }
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        return this;
    }

    public RestClientBuilderImpl proxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public RestClientBuilderImpl proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return this;
    }

    public RestClientBuilderImpl nonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
        return this;
    }

    public RestClientBuilderImpl multipartPostEncoderMode(String mode) {
        this.multipartPostEncoderMode = mode;
        return this;
    }

    public RestClientBuilderImpl clientLogger(ClientLogger clientLogger) {
        this.clientLogger = clientLogger;
        return this;
    }

    public RestClientBuilderImpl loggingScope(LoggingScope loggingScope) {
        this.loggingScope = loggingScope;
        return this;
    }

    public RestClientBuilderImpl loggingBodyLimit(Integer limit) {
        this.loggingBodyLimit = limit;
        return this;
    }

    public RestClientBuilderImpl trustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public RestClientBuilderImpl executorService(ExecutorService executor) {
        throw new IllegalArgumentException("Specifying executor service is not supported. The underlying call in RestEasy Reactive is non-blocking, there is no reason to offload the call to a separate thread pool.");
    }

    public Configuration getConfiguration() {
        return this.clientBuilder.getConfiguration();
    }

    public RestClientBuilderImpl property(String name, Object value) {
        this.clientBuilder.property(name, value);
        return this;
    }

    public RestClientBuilderImpl register(Class<?> componentClass) {
        Object bean = BeanGrabber.getBeanIfDefined(componentClass);
        if (bean != null) {
            this.registerMpSpecificProvider(bean);
            this.clientBuilder.register(bean);
        } else {
            this.registerMpSpecificProvider(componentClass);
            this.clientBuilder.register(componentClass);
        }
        return this;
    }

    public RestClientBuilderImpl register(Class<?> componentClass, int priority) {
        InstanceHandle instance = Arc.container().instance(componentClass, new Annotation[0]);
        if (instance.isAvailable()) {
            this.registerMpSpecificProvider(instance.get());
            this.clientBuilder.register(instance.get(), priority);
        } else {
            this.registerMpSpecificProvider(componentClass);
            this.clientBuilder.register(componentClass, priority);
        }
        return this;
    }

    public RestClientBuilderImpl register(Class<?> componentClass, Class<?> ... contracts) {
        InstanceHandle instance = Arc.container().instance(componentClass, new Annotation[0]);
        if (instance.isAvailable()) {
            this.registerMpSpecificProvider(instance.get());
            this.clientBuilder.register(instance.get(), (Class[])contracts);
        } else {
            this.registerMpSpecificProvider(componentClass);
            this.clientBuilder.register(componentClass, (Class[])contracts);
        }
        return this;
    }

    public RestClientBuilderImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        InstanceHandle instance = Arc.container().instance(componentClass, new Annotation[0]);
        if (instance.isAvailable()) {
            this.registerMpSpecificProvider(instance.get());
            this.clientBuilder.register(instance.get(), contracts);
        } else {
            this.registerMpSpecificProvider(componentClass);
            this.clientBuilder.register(componentClass, contracts);
        }
        return this;
    }

    public RestClientBuilderImpl register(Object component) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component);
        return this;
    }

    public RestClientBuilderImpl register(Object component, int priority) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component, priority);
        return this;
    }

    public RestClientBuilderImpl register(Object component, Class<?> ... contracts) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component, (Class[])contracts);
        return this;
    }

    public RestClientBuilderImpl register(Object component, Map<Class<?>, Integer> contracts) {
        this.registerMpSpecificProvider(component);
        this.clientBuilder.register(component, contracts);
        return this;
    }

    public RestClientBuilderImpl baseUri(URI uri) {
        this.uri = uri;
        return this;
    }

    private void registerMpSpecificProvider(Class<?> componentClass) {
        if (ResponseExceptionMapper.class.isAssignableFrom(componentClass) || ParamConverterProvider.class.isAssignableFrom(componentClass)) {
            try {
                this.registerMpSpecificProvider(componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to instantiate provider " + componentClass + ". Does it have a public no-arg constructor?", e);
            }
        }
    }

    private void registerMpSpecificProvider(Object component) {
        if (component instanceof ResponseExceptionMapper) {
            this.exceptionMappers.add((ResponseExceptionMapper)component);
        }
        if (component instanceof ParamConverterProvider) {
            this.paramConverterProviders.add((ParamConverterProvider)component);
        }
    }

    public RestClientBuilderImpl queryParamStyle(QueryParamStyle style) {
        this.queryParamStyle = style;
        return this;
    }

    public <T> T build(Class<T> aClass) throws IllegalStateException, RestClientDefinitionException {
        Integer effectiveLoggingBodyLimit;
        if (this.uri == null) {
            throw new IllegalStateException("No URL specified. Cannot build a rest client without URL");
        }
        ArcContainer arcContainer = Arc.container();
        if (arcContainer == null) {
            throw new IllegalStateException("The Reactive REST Client needs to be built within the context of a Quarkus application with a valid ArC (CDI) context running.");
        }
        RestClientListeners.get().forEach(listener -> listener.onNewClient(aClass, (RestClientBuilder)this));
        AnnotationRegisteredProviders annotationRegisteredProviders = (AnnotationRegisteredProviders)arcContainer.instance(AnnotationRegisteredProviders.class, new Annotation[0]).get();
        for (Map.Entry<Class<?>, Integer> mapper : annotationRegisteredProviders.getProviders(aClass).entrySet()) {
            this.register(mapper.getKey(), (int)mapper.getValue());
        }
        Object defaultMapperDisabled = this.getConfiguration().getProperty(DEFAULT_MAPPER_DISABLED);
        Boolean globallyDisabledMapper = ConfigProvider.getConfig().getOptionalValue(DEFAULT_MAPPER_DISABLED, Boolean.class).orElse(false);
        if (!(globallyDisabledMapper.booleanValue() || defaultMapperDisabled instanceof Boolean && ((Boolean)defaultMapperDisabled).booleanValue())) {
            this.exceptionMappers.add(new DefaultMicroprofileRestClientExceptionMapper());
        }
        this.exceptionMappers.sort(Comparator.comparingInt(ResponseExceptionMapper::getPriority));
        this.redirectHandlers.sort(Comparator.comparingInt(RedirectHandler::getPriority));
        this.clientBuilder.register((Object)new MicroProfileRestClientResponseFilter(this.exceptionMappers));
        this.clientBuilder.followRedirects(this.followRedirects);
        RestClientsConfig restClientsConfig = (RestClientsConfig)arcContainer.instance(RestClientsConfig.class, new Annotation[0]).get();
        RestClientLoggingConfig logging = restClientsConfig.logging;
        LoggingScope effectiveLoggingScope = this.loggingScope;
        if (effectiveLoggingScope == null) {
            LoggingScope loggingScope = effectiveLoggingScope = logging != null ? logging.scope.map(LoggingScope::forName).orElse(LoggingScope.NONE) : LoggingScope.NONE;
        }
        if ((effectiveLoggingBodyLimit = this.loggingBodyLimit) == null) {
            effectiveLoggingBodyLimit = logging != null ? logging.bodyLimit : 100;
        }
        this.clientBuilder.loggingScope(effectiveLoggingScope);
        this.clientBuilder.loggingBodySize(effectiveLoggingBodyLimit);
        if (this.clientLogger != null) {
            this.clientBuilder.clientLogger(this.clientLogger);
        } else {
            InstanceHandle clientLoggerInstance = arcContainer.instance(ClientLogger.class, new Annotation[0]);
            if (clientLoggerInstance.isAvailable()) {
                this.clientBuilder.clientLogger((ClientLogger)clientLoggerInstance.get());
            }
        }
        this.clientBuilder.multiQueryParamMode(this.toMultiQueryParamMode(this.queryParamStyle));
        Boolean effectiveTrustAll = this.trustAll;
        if (effectiveTrustAll == null) {
            effectiveTrustAll = ConfigProvider.getConfig().getOptionalValue(TLS_TRUST_ALL, Boolean.class).orElse(false);
        }
        this.clientBuilder.trustAll(effectiveTrustAll.booleanValue());
        restClientsConfig.verifyHost.ifPresent(arg_0 -> ((ClientBuilderImpl)this.clientBuilder).verifyHost(arg_0));
        String userAgent = (String)this.getConfiguration().getProperty("io.quarkus.rest.client.user-agent");
        if (userAgent != null) {
            this.clientBuilder.setUserAgent(userAgent);
        } else if (restClientsConfig.userAgent.isPresent()) {
            this.clientBuilder.setUserAgent((String)restClientsConfig.userAgent.get());
        }
        Integer maxChunkSize = (Integer)this.getConfiguration().getProperty("io.quarkus.rest.client.max-chunk-size");
        if (maxChunkSize != null) {
            this.clientBuilder.maxChunkSize(maxChunkSize.intValue());
        } else if (restClientsConfig.maxChunkSize.isPresent()) {
            this.clientBuilder.maxChunkSize((int)((MemorySize)restClientsConfig.maxChunkSize.get()).asLongValue());
        } else if (restClientsConfig.multipart.maxChunkSize.isPresent()) {
            this.clientBuilder.maxChunkSize(((Integer)restClientsConfig.multipart.maxChunkSize.get()).intValue());
        } else {
            this.clientBuilder.maxChunkSize(8096);
        }
        if (this.getConfiguration().hasProperty("io.quarkus.rest.client.http2")) {
            this.clientBuilder.http2(((Boolean)this.getConfiguration().getProperty("io.quarkus.rest.client.http2")).booleanValue());
        } else if (restClientsConfig.http2) {
            this.clientBuilder.http2(true);
        }
        if (this.getConfiguration().hasProperty("io.quarkus.rest.client.alpn")) {
            this.clientBuilder.alpn(((Boolean)this.getConfiguration().getProperty("io.quarkus.rest.client.alpn")).booleanValue());
        } else if (restClientsConfig.alpn.isPresent()) {
            this.clientBuilder.alpn(((Boolean)restClientsConfig.alpn.get()).booleanValue());
        }
        Boolean enableCompression = ConfigProvider.getConfig().getOptionalValue(ENABLE_COMPRESSION, Boolean.class).orElse(false);
        if (enableCompression.booleanValue()) {
            this.clientBuilder.enableCompression();
        }
        if (this.proxyHost != null) {
            this.configureProxy(this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword, this.nonProxyHosts);
        } else if (restClientsConfig.proxyAddress.isPresent()) {
            ProxyAddressUtil.HostAndPort globalProxy = ProxyAddressUtil.parseAddress((String)restClientsConfig.proxyAddress.get());
            this.configureProxy(globalProxy.host, globalProxy.port, restClientsConfig.proxyUser.orElse(null), restClientsConfig.proxyPassword.orElse(null), restClientsConfig.nonProxyHosts.orElse(null));
        }
        if (!this.clientBuilder.getConfiguration().hasProperty("io.quarkus.rest.client.multipart-post-encoder-mode")) {
            PausableHttpPostRequestEncoder.EncoderMode multipartPostEncoderMode = null;
            if (this.multipartPostEncoderMode != null) {
                multipartPostEncoderMode = PausableHttpPostRequestEncoder.EncoderMode.valueOf((String)this.multipartPostEncoderMode.toUpperCase(Locale.ROOT));
            } else if (restClientsConfig.multipartPostEncoderMode.isPresent()) {
                multipartPostEncoderMode = PausableHttpPostRequestEncoder.EncoderMode.valueOf((String)((String)restClientsConfig.multipartPostEncoderMode.get()).toUpperCase(Locale.ROOT));
            }
            if (multipartPostEncoderMode != null) {
                this.clientBuilder.property("io.quarkus.rest.client.multipart-post-encoder-mode", (Object)multipartPostEncoderMode);
            }
        }
        ClientImpl client = this.clientBuilder.build();
        WebTargetImpl target = (WebTargetImpl)client.target(this.uri);
        target.setParamConverterProviders(this.paramConverterProviders);
        try {
            return (T)target.proxy(aClass);
        }
        catch (InvalidRestClientDefinitionException e) {
            throw new RestClientDefinitionException((Throwable)e);
        }
    }

    private void configureProxy(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, String nonProxyHosts) {
        if (proxyHost != null) {
            this.clientBuilder.proxy(proxyHost, proxyPort.intValue());
            if (proxyUser != null && proxyPassword != null) {
                this.clientBuilder.proxyUser(proxyUser);
                this.clientBuilder.proxyPassword(proxyPassword);
            }
            if (nonProxyHosts != null) {
                this.clientBuilder.nonProxyHosts(nonProxyHosts);
            }
        }
    }

    private MultiQueryParamMode toMultiQueryParamMode(QueryParamStyle queryParamStyle) {
        if (queryParamStyle == null) {
            return null;
        }
        switch (queryParamStyle) {
            case MULTI_PAIRS: {
                return MultiQueryParamMode.MULTI_PAIRS;
            }
            case COMMA_SEPARATED: {
                return MultiQueryParamMode.COMMA_SEPARATED;
            }
            case ARRAY_PAIRS: {
                return MultiQueryParamMode.ARRAY_PAIRS;
            }
        }
        return null;
    }
}

