/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.geo;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import io.quarkus.redis.datasource.codecs.Codec;
import io.quarkus.redis.datasource.geo.GeoUnit;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class GeoSearchArgs<V>
implements RedisCommandExtraArguments {
    private V member;
    private double longitude = Double.MIN_VALUE;
    private double latitude = Double.MIN_VALUE;
    private double radius = -1.0;
    private double width = -1.0;
    private double height = -1.0;
    private GeoUnit unit;
    private long count = -1L;
    private boolean any;
    private String direction;
    private boolean withDistance;
    private boolean withCoordinates;
    private boolean withHash;

    public GeoSearchArgs<V> fromMember(V member) {
        if (member == null) {
            throw new IllegalArgumentException("`member` cannot be `null`");
        }
        this.member = member;
        return this;
    }

    public GeoSearchArgs<V> fromCoordinate(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        return this;
    }

    public GeoSearchArgs<V> byRadius(double radius, GeoUnit unit) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("`radius` must be positive");
        }
        if (unit == null) {
            throw new IllegalArgumentException("`unit` cannot be `null`");
        }
        this.radius = radius;
        this.unit = unit;
        return this;
    }

    public GeoSearchArgs<V> byBox(double width, double height, GeoUnit unit) {
        if (width < 0.0) {
            throw new IllegalArgumentException("`width` must be positive");
        }
        if (height < 0.0) {
            throw new IllegalArgumentException("`height` must be positive");
        }
        if (unit == null) {
            throw new IllegalArgumentException("`unit` cannot be `null`");
        }
        this.width = width;
        this.height = height;
        this.unit = unit;
        return this;
    }

    public GeoSearchArgs<V> ascending() {
        this.direction = "ASC";
        return this;
    }

    public GeoSearchArgs<V> descending() {
        this.direction = "DESC";
        return this;
    }

    public GeoSearchArgs<V> withDistance() {
        this.withDistance = true;
        return this;
    }

    public GeoSearchArgs<V> withCoordinates() {
        this.withCoordinates = true;
        return this;
    }

    public GeoSearchArgs<V> withHash() {
        this.withHash = true;
        return this;
    }

    public GeoSearchArgs<V> count(long count) {
        this.count = count;
        return this;
    }

    public GeoSearchArgs<V> any() {
        this.any = true;
        return this;
    }

    @Override
    public List<String> toArgs(Codec codec) {
        if (this.any && this.count == -1L) {
            throw new IllegalArgumentException("ANY can only be used if COUNT is also set");
        }
        if (this.radius > 0.0 && this.width > 0.0) {
            throw new IllegalArgumentException("BYRADIUS and BYBOX cannot be used together");
        }
        if (this.member != null && (this.latitude != Double.MIN_VALUE || this.longitude != Double.MIN_VALUE)) {
            throw new IllegalArgumentException("FROMMEMBER and FROMLONLAT cannot be used together");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.member != null) {
            list.add("FROMMEMBER");
            list.add(new String(codec.encode(this.member), StandardCharsets.UTF_8));
        } else {
            list.add("FROMLONLAT");
            list.add(Double.toString(this.longitude));
            list.add(Double.toString(this.latitude));
        }
        if (this.radius > 0.0) {
            list.add("BYRADIUS");
            list.add(Double.toString(this.radius));
            list.add(this.unit.toString());
        } else {
            list.add("BYBOX");
            list.add(Double.toString(this.width));
            list.add(Double.toString(this.height));
            list.add(this.unit.toString());
        }
        if (this.direction != null) {
            list.add(this.direction);
        }
        if (this.count > 0L) {
            list.add("COUNT");
            list.add(Long.toString(this.count));
        }
        this.putFlag(list, this.any, "ANY");
        this.putFlag(list, this.withDistance, "WITHDIST");
        this.putFlag(list, this.withCoordinates, "WITHCOORD");
        this.putFlag(list, this.withHash, "WITHHASH");
        return list;
    }

    public boolean hasDistance() {
        return this.withDistance;
    }

    public boolean hasHash() {
        return this.withHash;
    }

    public boolean hasCoordinates() {
        return this.withCoordinates;
    }

    private void putFlag(List<String> list, boolean flag, String value) {
        if (flag) {
            list.add(value);
        }
    }
}

