/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.topk.ReactiveTransactionalTopKCommands;
import io.quarkus.redis.datasource.transactions.ReactiveTransactionalRedisDataSource;
import io.quarkus.redis.runtime.datasource.AbstractTransactionalCommands;
import io.quarkus.redis.runtime.datasource.ReactiveTopKCommandsImpl;
import io.quarkus.redis.runtime.datasource.TransactionHolder;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.redis.client.Response;
import java.util.Map;

public class ReactiveTransactionalTopKCommandsImpl<K, V>
extends AbstractTransactionalCommands
implements ReactiveTransactionalTopKCommands<K, V> {
    private final ReactiveTopKCommandsImpl<K, V> reactive;

    public ReactiveTransactionalTopKCommandsImpl(ReactiveTransactionalRedisDataSource ds, ReactiveTopKCommandsImpl<K, V> reactive, TransactionHolder tx) {
        super(ds, tx);
        this.reactive = reactive;
    }

    @Override
    public Uni<Void> topkAdd(K key, V item) {
        this.tx.enqueue(r -> this.reactive.marshaller.decodeAsList((Response)r, this.reactive.typeOfValue).get(0));
        return this.reactive._topkAdd(key, item).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> topkAdd(K key, V ... items) {
        this.tx.enqueue(r -> this.reactive.marshaller.decodeAsList((Response)r, this.reactive.typeOfValue));
        return this.reactive._topkAdd(key, items).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> topkIncrBy(K key, V item, int increment) {
        this.tx.enqueue(r -> this.reactive.marshaller.decodeAsList((Response)r, this.reactive.typeOfValue).get(0));
        return this.reactive._topkIncrBy(key, item, increment).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> topkIncrBy(K key, Map<V, Integer> couples) {
        this.tx.enqueue(r -> this.reactive.decodeAsMapVV(couples, (Response)r));
        return this.reactive._topkIncrBy(key, couples).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> topkList(K key) {
        this.tx.enqueue(r -> this.reactive.marshaller.decodeAsList((Response)r, this.reactive.typeOfValue));
        return this.reactive._topkList(key).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> topkListWithCount(K key) {
        this.tx.enqueue(this.reactive::decodeAsMapVInt);
        return this.reactive._topkListWithCount(key).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> topkQuery(K key, V item) {
        this.tx.enqueue(r -> this.reactive.marshaller.decodeAsList((Response)r, Response::toBoolean).get(0));
        return this.reactive._topkQuery(key, item).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> topkQuery(K key, V ... items) {
        this.tx.enqueue(r -> this.reactive.marshaller.decodeAsList((Response)r, Response::toBoolean));
        return this.reactive._topkQuery(key, items).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> topkReserve(K key, int topk) {
        this.tx.enqueue(r -> null);
        return this.reactive._topkReserve(key, topk).invoke(this::queuedOrDiscard).replaceWithVoid();
    }

    @Override
    public Uni<Void> topkReserve(K key, int topk, int width, int depth, double decay) {
        this.tx.enqueue(r -> null);
        return this.reactive._topkReserve(key, topk, width, depth, decay).invoke(this::queuedOrDiscard).replaceWithVoid();
    }
}

