/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.bitmap.ReactiveTransactionalBitMapCommands;
import io.quarkus.redis.datasource.geo.ReactiveTransactionalGeoCommands;
import io.quarkus.redis.datasource.hash.ReactiveTransactionalHashCommands;
import io.quarkus.redis.datasource.hyperloglog.ReactiveTransactionalHyperLogLogCommands;
import io.quarkus.redis.datasource.keys.ReactiveTransactionalKeyCommands;
import io.quarkus.redis.datasource.list.ReactiveTransactionalListCommands;
import io.quarkus.redis.datasource.set.ReactiveTransactionalSetCommands;
import io.quarkus.redis.datasource.sortedset.ReactiveTransactionalSortedSetCommands;
import io.quarkus.redis.datasource.string.ReactiveTransactionalStringCommands;
import io.quarkus.redis.datasource.transactions.ReactiveTransactionalRedisDataSource;
import io.quarkus.redis.datasource.value.ReactiveTransactionalValueCommands;
import io.quarkus.redis.runtime.datasource.ReactiveBitMapCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveGeoCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveHashCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveHyperLogLogCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveKeyCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveListCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.ReactiveSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveSortedSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveStringCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalBitMapCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalGeoCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalHashCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalHyperLogLogCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalKeyCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalListCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalSortedSetCommandsImpl;
import io.quarkus.redis.runtime.datasource.ReactiveTransactionalStringCommandsImpl;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.TransactionHolder;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.redis.client.Command;
import java.util.Arrays;

public class ReactiveTransactionalRedisDataSourceImpl
implements ReactiveTransactionalRedisDataSource {
    private final ReactiveRedisDataSourceImpl reactive;
    private final TransactionHolder tx;

    public ReactiveTransactionalRedisDataSourceImpl(ReactiveRedisDataSource source, TransactionHolder th) {
        this.tx = th;
        this.reactive = (ReactiveRedisDataSourceImpl)source;
    }

    @Override
    public Uni<Void> discard() {
        return this.reactive.execute(io.vertx.mutiny.redis.client.Command.DISCARD, new String[0]).invoke(this.tx::discard).replaceWithVoid();
    }

    @Override
    public boolean discarded() {
        return this.tx.discarded();
    }

    @Override
    public <K, F, V> ReactiveTransactionalHashCommands<K, F, V> hash(Class<K> redisKeyType, Class<F> typeOfField, Class<V> typeOfValue) {
        return new ReactiveTransactionalHashCommandsImpl(this, (ReactiveHashCommandsImpl)this.reactive.hash(redisKeyType, typeOfField, typeOfValue), this.tx);
    }

    @Override
    public <K, V> ReactiveTransactionalGeoCommands<K, V> geo(Class<K> redisKeyType, Class<V> memberType) {
        return new ReactiveTransactionalGeoCommandsImpl(this, (ReactiveGeoCommandsImpl)this.reactive.geo(redisKeyType, memberType), this.tx);
    }

    @Override
    public <K, V> ReactiveTransactionalSortedSetCommands<K, V> sortedSet(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveTransactionalSortedSetCommandsImpl(this, (ReactiveSortedSetCommandsImpl)this.reactive.sortedSet(redisKeyType, valueType), this.tx);
    }

    @Override
    public <K, V> ReactiveTransactionalValueCommands<K, V> value(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveTransactionalStringCommandsImpl(this, (ReactiveStringCommandsImpl)this.reactive.value(redisKeyType, valueType), this.tx);
    }

    @Override
    public <K, V> ReactiveTransactionalStringCommands<K, V> string(Class<K> redisKeyType, Class<V> valueType) {
        return new ReactiveTransactionalStringCommandsImpl(this, (ReactiveStringCommandsImpl)this.reactive.value(redisKeyType, valueType), this.tx);
    }

    @Override
    public <K, V> ReactiveTransactionalSetCommands<K, V> set(Class<K> redisKeyType, Class<V> memberType) {
        return new ReactiveTransactionalSetCommandsImpl(this, (ReactiveSetCommandsImpl)this.reactive.set(redisKeyType, memberType), this.tx);
    }

    @Override
    public <K, V> ReactiveTransactionalListCommands<K, V> list(Class<K> redisKeyType, Class<V> memberType) {
        return new ReactiveTransactionalListCommandsImpl(this, (ReactiveListCommandsImpl)this.reactive.list(redisKeyType, memberType), this.tx);
    }

    @Override
    public <K, V> ReactiveTransactionalHyperLogLogCommands<K, V> hyperloglog(Class<K> redisKeyType, Class<V> memberType) {
        return new ReactiveTransactionalHyperLogLogCommandsImpl(this, (ReactiveHyperLogLogCommandsImpl)this.reactive.hyperloglog(redisKeyType, memberType), this.tx);
    }

    @Override
    public <K> ReactiveTransactionalBitMapCommands<K> bitmap(Class<K> redisKeyType) {
        return new ReactiveTransactionalBitMapCommandsImpl(this, (ReactiveBitMapCommandsImpl)this.reactive.bitmap(redisKeyType), this.tx);
    }

    @Override
    public <K> ReactiveTransactionalKeyCommands<K> key(Class<K> redisKeyType) {
        return new ReactiveTransactionalKeyCommandsImpl(this, (ReactiveKeyCommandsImpl)this.reactive.key(redisKeyType), this.tx);
    }

    @Override
    public Uni<Void> execute(String command, String ... args) {
        ParameterValidation.nonNull((Object)command, (String)"command");
        return this.execute(io.vertx.mutiny.redis.client.Command.create((String)command), args);
    }

    @Override
    public Uni<Void> execute(io.vertx.mutiny.redis.client.Command command, String ... args) {
        ParameterValidation.nonNull((Object)command, (String)"command");
        this.tx.enqueue(r -> r);
        RedisCommand c = RedisCommand.of(command).putAll(Arrays.asList(args));
        return this.reactive.execute(c.toRequest()).map(r -> {
            if (r == null || !r.toString().equals("QUEUED")) {
                this.tx.discard();
                throw new IllegalStateException("Unable to enqueue command into the current transaction");
            }
            return r;
        }).replaceWithVoid();
    }

    @Override
    public Uni<Void> execute(Command command, String ... args) {
        ParameterValidation.nonNull((Object)command, (String)"command");
        return this.execute(new io.vertx.mutiny.redis.client.Command(command), args);
    }
}

