/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client;

import io.quarkus.redis.client.RedisClient;
import io.quarkus.redis.client.reactive.ReactiveRedisClient;
import io.quarkus.redis.datasource.ReactiveRedisDataSource;
import io.quarkus.redis.datasource.RedisDataSource;
import io.quarkus.redis.runtime.client.ReactiveRedisClientImpl;
import io.quarkus.redis.runtime.client.RedisClientImpl;
import io.quarkus.redis.runtime.client.VertxRedisClientFactory;
import io.quarkus.redis.runtime.client.config.RedisClientConfig;
import io.quarkus.redis.runtime.client.config.RedisConfig;
import io.quarkus.redis.runtime.datasource.BlockingRedisDataSourceImpl;
import io.quarkus.redis.runtime.datasource.ReactiveRedisDataSourceImpl;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.core.Vertx;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.mutiny.redis.client.RedisAPI;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class RedisClientRecorder {
    private final RedisConfig config;
    private final Map<String, RedisClientAndApi> clients = new HashMap<String, RedisClientAndApi>();
    private final Map<String, ReactiveRedisDataSourceImpl> dataSources = new HashMap<String, ReactiveRedisDataSourceImpl>();

    public RedisClientRecorder(RedisConfig rc) {
        this.config = rc;
    }

    public void initialize(RuntimeValue<Vertx> vertx, Set<String> names) {
        io.vertx.mutiny.core.Vertx v = io.vertx.mutiny.core.Vertx.newInstance((Vertx)((Vertx)vertx.getValue()));
        this._initialize(v, names);
    }

    public void _initialize(io.vertx.mutiny.core.Vertx vertx, Set<String> names) {
        for (final String name : names) {
            Optional<RedisClientConfig> maybe = RedisClientRecorder.getConfigForName(this.config, name);
            if (!RedisConfig.isDefaultClient(name)) {
                RedisClientConfig actualConfig = maybe.orElseThrow(new Supplier<ConfigurationException>(){

                    @Override
                    public ConfigurationException get() {
                        return new ConfigurationException("The application contains a @RedisClientName(\"" + name + "\"), but the application configuration does not configure this redis client configuration with that name. You must at least configure `quarkus.redis." + name + ".hosts`.");
                    }
                });
                this.clients.computeIfAbsent(name, x -> new RedisClientAndApi(VertxRedisClientFactory.create(vertx, actualConfig)));
                continue;
            }
            if (!"<default>".equalsIgnoreCase(name) || !maybe.isPresent()) continue;
            this.clients.computeIfAbsent(name, x -> new RedisClientAndApi(VertxRedisClientFactory.create(vertx, (RedisClientConfig)maybe.get())));
        }
    }

    static Optional<RedisClientConfig> getConfigForName(RedisConfig cfg, String name) {
        if (RedisConfig.isDefaultClient(name)) {
            return Optional.ofNullable(cfg.defaultRedisClient);
        }
        for (Map.Entry<String, RedisClientConfig> entry : cfg.namedRedisClients.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Supplier<Redis> getRedisClient(final String name) {
        return new Supplier<Redis>(){

            @Override
            public Redis get() {
                return RedisClientRecorder.this.clients.get((Object)name).redis;
            }
        };
    }

    public Supplier<io.vertx.redis.client.Redis> getBareRedisClient(final String name) {
        return new Supplier<io.vertx.redis.client.Redis>(){

            @Override
            public io.vertx.redis.client.Redis get() {
                return RedisClientRecorder.this.clients.get((Object)name).redis.getDelegate();
            }
        };
    }

    public Supplier<RedisAPI> getRedisAPI(final String name) {
        return new Supplier<RedisAPI>(){

            @Override
            public RedisAPI get() {
                return RedisClientRecorder.this.clients.get((Object)name).api;
            }
        };
    }

    public Supplier<io.vertx.redis.client.RedisAPI> getBareRedisAPI(final String name) {
        return new Supplier<io.vertx.redis.client.RedisAPI>(){

            @Override
            public io.vertx.redis.client.RedisAPI get() {
                return RedisClientRecorder.this.clients.get((Object)name).api.getDelegate();
            }
        };
    }

    public Supplier<ReactiveRedisDataSource> getReactiveDataSource(final String name) {
        return new Supplier<ReactiveRedisDataSource>(){

            @Override
            public ReactiveRedisDataSource get() {
                return RedisClientRecorder.this.dataSources.computeIfAbsent(name, k -> {
                    RedisClientAndApi redisClientAndApi = RedisClientRecorder.this.clients.get(name);
                    Redis redis = redisClientAndApi.redis;
                    RedisAPI api = redisClientAndApi.api;
                    return new ReactiveRedisDataSourceImpl(redis, api);
                });
            }
        };
    }

    public Supplier<RedisDataSource> getBlockingDataSource(final String name) {
        return new Supplier<RedisDataSource>(){

            @Override
            public RedisDataSource get() {
                Duration timeout = RedisClientRecorder.this.getTimeoutForClient(name);
                return new BlockingRedisDataSourceImpl((ReactiveRedisDataSourceImpl)RedisClientRecorder.this.getReactiveDataSource(name).get(), timeout);
            }
        };
    }

    public Supplier<RedisClient> getLegacyRedisClient(final String name) {
        return new Supplier<RedisClient>(){

            @Override
            public RedisClient get() {
                Duration timeout = RedisClientRecorder.this.getTimeoutForClient(name);
                return new RedisClientImpl(RedisClientRecorder.this.getRedisClient(name).get(), RedisClientRecorder.this.getRedisAPI(name).get(), timeout);
            }
        };
    }

    private Duration getTimeoutForClient(String name) {
        Duration timeout = RedisConfig.isDefaultClient(name) ? this.config.defaultRedisClient.timeout : this.config.namedRedisClients.get((Object)name).timeout;
        return timeout;
    }

    public Supplier<ReactiveRedisClient> getLegacyReactiveRedisClient(final String name) {
        return new Supplier<ReactiveRedisClient>(){

            @Override
            public ReactiveRedisClient get() {
                return new ReactiveRedisClientImpl(RedisClientRecorder.this.getRedisClient(name).get(), RedisClientRecorder.this.getRedisAPI(name).get());
            }
        };
    }

    public void cleanup(ShutdownContext context) {
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                for (RedisClientAndApi value : RedisClientRecorder.this.clients.values()) {
                    value.redis.close();
                }
                RedisClientRecorder.this.clients.clear();
            }
        });
    }

    private static class RedisClientAndApi {
        private final Redis redis;
        private final RedisAPI api;

        private RedisClientAndApi(Redis redis) {
            this.redis = redis;
            this.api = RedisAPI.api((Redis)redis);
        }
    }
}

