/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.ScanArgs;
import io.quarkus.redis.datasource.hash.HashCommands;
import io.quarkus.redis.datasource.hash.HashScanCursor;
import io.quarkus.redis.datasource.hash.ReactiveHashCommands;
import io.quarkus.redis.runtime.datasource.HashScanBlockingCursorImpl;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class BlockingHashCommandsImpl<K, F, V>
implements HashCommands<K, F, V> {
    private final ReactiveHashCommands<K, F, V> reactive;
    private final Duration timeout;

    public BlockingHashCommandsImpl(ReactiveHashCommands<K, F, V> reactive, Duration timeout) {
        this.reactive = reactive;
        this.timeout = timeout;
    }

    @Override
    public int hdel(K key, F ... fields) {
        return (Integer)this.reactive.hdel(key, fields).await().atMost(this.timeout);
    }

    @Override
    public boolean hexists(K key, F field) {
        return (Boolean)this.reactive.hexists(key, field).await().atMost(this.timeout);
    }

    @Override
    public V hget(K key, F field) {
        return (V)this.reactive.hget(key, field).await().atMost(this.timeout);
    }

    @Override
    public long hincrby(K key, F field, long amount) {
        return (Long)this.reactive.hincrby(key, field, amount).await().atMost(this.timeout);
    }

    @Override
    public double hincrbyfloat(K key, F field, double amount) {
        return (Double)this.reactive.hincrbyfloat(key, field, amount).await().atMost(this.timeout);
    }

    @Override
    public Map<F, V> hgetall(K key) {
        return (Map)this.reactive.hgetall(key).await().atMost(this.timeout);
    }

    @Override
    public List<F> hkeys(K key) {
        return (List)this.reactive.hkeys(key).await().atMost(this.timeout);
    }

    @Override
    public long hlen(K key) {
        return (Long)this.reactive.hlen(key).await().atMost(this.timeout);
    }

    @Override
    public Map<F, V> hmget(K key, F ... fields) {
        return (Map)this.reactive.hmget(key, fields).await().atMost(this.timeout);
    }

    @Override
    public void hmset(K key, Map<F, V> map) {
        this.reactive.hmset(key, map).await().atMost(this.timeout);
    }

    @Override
    public F hrandfield(K key) {
        return (F)this.reactive.hrandfield(key).await().atMost(this.timeout);
    }

    @Override
    public List<F> hrandfield(K key, long count) {
        return (List)this.reactive.hrandfield(key, count).await().atMost(this.timeout);
    }

    @Override
    public Map<F, V> hrandfieldWithValues(K key, long count) {
        return (Map)this.reactive.hrandfieldWithValues(key, count).await().atMost(this.timeout);
    }

    @Override
    public HashScanCursor<F, V> hscan(K key) {
        return new HashScanBlockingCursorImpl<F, V>(this.reactive.hscan(key), this.timeout);
    }

    @Override
    public HashScanCursor<F, V> hscan(K key, ScanArgs scanArgs) {
        return new HashScanBlockingCursorImpl<F, V>(this.reactive.hscan(key, scanArgs), this.timeout);
    }

    @Override
    public boolean hset(K key, F field, V value) {
        return (Boolean)this.reactive.hset(key, field, value).await().atMost(this.timeout);
    }

    @Override
    public long hset(K key, Map<F, V> map) {
        return (Long)this.reactive.hset(key, map).await().atMost(this.timeout);
    }

    @Override
    public boolean hsetnx(K key, F field, V value) {
        return (Boolean)this.reactive.hsetnx(key, field, value).await().atMost(this.timeout);
    }

    @Override
    public long hstrlen(K key, F field) {
        return (Long)this.reactive.hstrlen(key, field).await().atMost(this.timeout);
    }

    @Override
    public List<V> hvals(K key) {
        return (List)this.reactive.hvals(key).await().atMost(this.timeout);
    }
}

