/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.vertx.sqlclient.Pool;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;

public final class ReactiveDataSourceUtil {
    private ReactiveDataSourceUtil() {
    }

    public static String dataSourceName(Bean<? extends Pool> bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof ReactiveDataSource)) continue;
            return ((ReactiveDataSource)qualifier).value();
        }
        return "<default>";
    }

    public static Annotation qualifier(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return Default.Literal.INSTANCE;
        }
        return new ReactiveDataSource.ReactiveDataSourceLiteral(dataSourceName);
    }
}

