/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.runtime;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveRuntimeConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.Map;

@ConfigMapping(prefix="quarkus.datasource")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface DataSourcesReactiveRuntimeConfig {
    @WithName(value="reactive")
    public DataSourceReactiveRuntimeConfig defaultDataSource();

    @WithParentName
    @WithDefaults
    public Map<String, DataSourceReactiveOuterNamedRuntimeConfig> namedDataSources();

    default public DataSourceReactiveRuntimeConfig getDataSourceReactiveRuntimeConfig(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return this.defaultDataSource();
        }
        return this.namedDataSources().get(dataSourceName).reactive();
    }

    @ConfigGroup
    public static interface DataSourceReactiveOuterNamedRuntimeConfig {
        public DataSourceReactiveRuntimeConfig reactive();
    }
}

