/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import io.quarkus.quartz.runtime.QuartzBuildTimeConfig;
import io.quarkus.quartz.runtime.QuartzRuntimeConfig;
import io.quarkus.scheduler.common.runtime.ScheduledMethod;
import java.util.Optional;
import java.util.Set;

public class QuartzSupport {
    private final QuartzRuntimeConfig runtimeConfig;
    private final QuartzBuildTimeConfig buildTimeConfig;
    private final Optional<String> driverDialect;
    private final Set<String> nonconcurrentMethods;

    public QuartzSupport(QuartzRuntimeConfig runtimeConfig, QuartzBuildTimeConfig buildTimeConfig, Optional<String> driverDialect, Set<String> nonconcurrentMethods) {
        this.runtimeConfig = runtimeConfig;
        this.buildTimeConfig = buildTimeConfig;
        this.driverDialect = driverDialect;
        this.nonconcurrentMethods = Set.copyOf(nonconcurrentMethods);
    }

    public QuartzRuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public QuartzBuildTimeConfig getBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    public Optional<String> getDriverDialect() {
        return this.driverDialect;
    }

    public boolean isNonconcurrent(ScheduledMethod method) {
        return this.nonconcurrentMethods.contains(method.getMethodDescription());
    }
}

