/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import io.quarkus.quartz.runtime.QuartzMisfirePolicy;
import io.quarkus.quartz.runtime.QuartzStartMode;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class QuartzRuntimeConfig {
    @ConfigItem(defaultValue="QuarkusQuartzScheduler")
    public String instanceName;
    @ConfigItem(defaultValue="AUTO")
    public String instanceId;
    @ConfigItem(defaultValue="0")
    public long batchTriggerAcquisitionFireAheadTimeWindow;
    @ConfigItem(defaultValue="1")
    public int batchTriggerAcquisitionMaxCount;
    @ConfigItem(defaultValue="10")
    public int threadCount;
    @ConfigItem(defaultValue="5")
    public int threadPriority;
    @ConfigItem(defaultValue="60")
    public Duration misfireThreshold;
    @ConfigItem
    @Deprecated
    public Optional<QuartzStartMode> startMode;
    @ConfigItem(defaultValue="10")
    public Duration shutdownWaitTime;
    @ConfigItem(name="simple-trigger")
    public TriggerConfig simpleTriggerConfig = TriggerConfig.defaultConfig();
    @ConfigItem(name="cron-trigger")
    public TriggerConfig cronTriggerConfig = TriggerConfig.defaultConfig();
    @ConfigDocSection
    @ConfigDocMapKey(value="identity")
    @ConfigItem(name="misfire-policy")
    public Map<String, QuartzMisfirePolicyConfig> misfirePolicyPerJobs;
    @ConfigDocMapKey(value="full-property-key")
    public Map<String, String> unsupportedProperties;
    @ConfigItem(defaultValue="false")
    public boolean runBlockingScheduledMethodOnQuartzThread;

    @ConfigGroup
    public static class TriggerConfig {
        @ConfigItem(name="misfire-policy")
        public QuartzMisfirePolicyConfig misfirePolicyConfig = QuartzMisfirePolicyConfig.defaultConfig();

        public static TriggerConfig defaultConfig() {
            return new TriggerConfig();
        }
    }

    @ConfigGroup
    public static class QuartzMisfirePolicyConfig {
        @ConfigItem(defaultValue="smart-policy", name="<<parent>>")
        public QuartzMisfirePolicy misfirePolicy;

        public static QuartzMisfirePolicyConfig defaultConfig() {
            return new QuartzMisfirePolicyConfig();
        }
    }
}

