/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.domino.scm;

import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import io.quarkus.domino.scm.ScmRepository;
import java.util.Objects;

public class ScmRevision
implements ReleaseVersion,
ReleaseId {
    private final ScmRepository repo;
    private final Kind kind;
    private final String value;

    public static ScmRevision tag(ScmRepository codeRepo, String tag) {
        return new ScmRevision(codeRepo, Kind.TAG, tag);
    }

    public static ScmRevision commit(ScmRepository codeRepo, String commit) {
        return new ScmRevision(codeRepo, Kind.COMMIT, commit);
    }

    public static ScmRevision branch(ScmRepository codeRepo, String branch) {
        return new ScmRevision(codeRepo, Kind.BRANCH, branch);
    }

    public static ScmRevision version(ScmRepository codeRepo, String version) {
        return new ScmRevision(codeRepo, Kind.VERSION, version);
    }

    private ScmRevision(ScmRepository codeRepo, Kind kind, String value) {
        this.repo = Objects.requireNonNull(codeRepo, "Code repository is missing");
        this.kind = Objects.requireNonNull(kind, "Revision kind is missing");
        this.value = Objects.requireNonNull(value, "Revision value is missing");
    }

    public ScmRepository getRepository() {
        return this.repo;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public ReleaseOrigin origin() {
        return this.repo;
    }

    @Override
    public ReleaseVersion version() {
        return this;
    }

    @Override
    public boolean isTag() {
        return this.kind == Kind.TAG;
    }

    @Override
    public String asString() {
        return this.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScmRevision revision = (ScmRevision)o;
        return Objects.equals(this.repo, revision.repo) && this.kind == revision.kind && Objects.equals(this.value, revision.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.repo, this.kind, this.value});
    }

    public String toString() {
        return this.repo.getId() + "#" + this.value;
    }

    public static enum Kind {
        COMMIT,
        TAG,
        BRANCH,
        VERSION;

    }
}

