/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.task;

import io.quarkus.bom.task.PlatformGenTask;
import io.quarkus.bom.task.PlatformGenTaskScheduler;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Phaser;

public class ParallelTaskScheduler
implements PlatformGenTaskScheduler {
    private final Phaser phaser = new Phaser(1);
    private final Deque<Exception> errors = new ConcurrentLinkedDeque<Exception>();
    private final Deque<PlatformGenTask> finalizingTasks = new ConcurrentLinkedDeque<PlatformGenTask>();

    @Override
    public void schedule(PlatformGenTask task) {
        this.phaser.register();
        CompletableFuture.runAsync(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                this.errors.add(e);
            }
            finally {
                this.phaser.arriveAndDeregister();
            }
        });
    }

    @Override
    public void addFinializingTask(PlatformGenTask task) {
        this.finalizingTasks.add(task);
    }

    @Override
    public void waitForCompletion() throws Exception {
        this.phaser.arriveAndAwaitAdvance();
        for (PlatformGenTask t : this.finalizingTasks) {
            t.run();
        }
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public Collection<Exception> getErrors() {
        return this.errors;
    }
}

