/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import org.eclipse.aether.artifact.Artifact;

public class GoogleApiCommonReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("com.google.api") && artifact.getArtifactId().equals("api-common")) {
            ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
            if (releaseId.isTag()) {
                return releaseId;
            }
            ScmRepository origin = releaseId.getRepository();
            if (origin.hasUrl() && origin.getUrl().equals("https://github.com/googleapis/sdk-platform-java")) {
                return ScmRevision.version(ScmRepository.ofId("com.google.api:api-common"), artifact.getVersion());
            }
        }
        return null;
    }
}

