/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import org.eclipse.aether.artifact.Artifact;

public class SisuPlexusReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("org.eclipse.sisu") && artifact.getArtifactId().contains("plexus")) {
            ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
            if (releaseId.getRepository().getId().equals("https://github.com/eclipse/sisu.plexus")) {
                return releaseId;
            }
            return ScmRevision.tag(ScmRepository.ofUrl("https://github.com/eclipse/sisu.plexus"), "releases/" + artifact.getVersion());
        }
        return null;
    }
}

