/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.ReleaseIdFactory;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import org.eclipse.aether.artifact.Artifact;

public class ReactiveStreamsReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("org.reactivestreams")) {
            ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
            Object repoUrl = releaseId.getRepository().getId();
            Object tag = releaseId.getValue();
            if (!((String)repoUrl).endsWith("reactive-streams-jvm")) {
                repoUrl = ((String)repoUrl).substring(0, ((String)repoUrl).lastIndexOf(47) + 1);
                repoUrl = (String)repoUrl + "reactive-streams-jvm";
            }
            if (((String)tag).charAt(0) != 'v') {
                tag = "v" + (String)tag;
            }
            return ReleaseIdFactory.forScmAndTag((String)repoUrl, (String)tag);
        }
        return null;
    }
}

