/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import org.eclipse.aether.artifact.Artifact;

public class HapiFhirReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("ca.uhn.hapi.fhir")) {
            Object version;
            ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
            ScmRepository origin = releaseId.getRepository();
            if (!origin.hasUrl() || !"https://github.com/hapifhir/hapi-fhir".equals(origin.getUrl())) {
                origin = ScmRepository.ofUrl("https://github.com/hapifhir/hapi-fhir");
            }
            if (!((String)(version = releaseId.getValue())).startsWith("v")) {
                version = (String)version + "v";
            }
            return ScmRevision.tag(origin, (String)version);
        }
        return null;
    }
}

