/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import org.eclipse.aether.artifact.Artifact;

public class AsmReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("org.ow2.asm")) {
            ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
            String version = releaseId.getValue();
            if (version.startsWith("ASM_")) {
                return releaseId;
            }
            version = version.replace('.', '_').toUpperCase();
            return ScmRevision.tag(releaseId.getRepository(), "ASM_" + version);
        }
        return null;
    }
}

