/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer.detector;

import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import org.eclipse.aether.artifact.Artifact;

public class Argparse4jReleaseIdDetector
implements ReleaseIdDetector {
    @Override
    public ScmRevision detectReleaseId(ScmRevisionResolver releaseResolver, Artifact artifact) throws BomDecomposerException {
        if (artifact.getGroupId().equals("net.sourceforge.argparse4j")) {
            Object version;
            ScmRevision releaseId = releaseResolver.readRevisionFromPom(artifact);
            ScmRepository origin = releaseId.getRepository();
            if (!origin.hasUrl() || !origin.getUrl().equals("https://github.com/argparse4j/argparse4j")) {
                origin = ScmRepository.ofUrl("https://github.com/argparse4j/argparse4j");
            }
            if (!((String)(version = releaseId.getValue())).startsWith("argparse4j-")) {
                version = "argparse4j-" + (String)version;
            }
            return ScmRevision.tag(origin, (String)version);
        }
        return null;
    }
}

