/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.decomposer.DefaultReleaseId;
import io.quarkus.bom.decomposer.ReleaseId;
import io.quarkus.bom.decomposer.ReleaseOrigin;
import io.quarkus.bom.decomposer.ReleaseVersion;
import io.quarkus.bom.decomposer.Util;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.domino.scm.ScmRepository;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.maven.dependency.ArtifactCoords;
import org.apache.maven.model.Model;

public class ReleaseIdFactory {
    public static ScmRevision forModel(Model model) {
        String version = ModelUtils.getVersion((Model)model);
        String scmOrigin = Util.getScmOrigin(model);
        if (scmOrigin != null) {
            String scmTag = Util.getScmTag(model);
            return scmTag.isEmpty() || "HEAD".equals(scmTag) ? ScmRevision.version(ScmRepository.ofUrl(scmOrigin), version) : ScmRevision.tag(ScmRepository.ofUrl(scmOrigin), scmTag);
        }
        return ReleaseIdFactory.forGav(ModelUtils.getGroupId((Model)model), model.getArtifactId(), version);
    }

    @Deprecated(forRemoval=true)
    public static ReleaseId create(ReleaseOrigin origin, ReleaseVersion version) {
        return new DefaultReleaseId(origin, version);
    }

    public static ScmRevision forGav(String groupId, String artifactId, String version) {
        return ScmRevision.version(ReleaseOrigin.Factory.ga(groupId, artifactId), version);
    }

    public static ScmRevision forGav(String coordsStr) {
        ArtifactCoords coords = ArtifactCoords.fromString((String)coordsStr);
        return ReleaseIdFactory.forGav(coords.getGroupId(), coords.getArtifactId(), coords.getVersion());
    }

    public static ScmRevision forScmAndTag(String scm, String tag) {
        return ScmRevision.tag(ScmRepository.ofUrl(scm), tag);
    }
}

